/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndian;

public final class PieceDescriptor {
    short descriptor;
    private static BitField fNoParaLast = BitFieldFactory.getInstance((int)1);
    private static BitField fPaphNil = BitFieldFactory.getInstance((int)2);
    private static BitField fCopied = BitFieldFactory.getInstance((int)4);
    int fc;
    short prm;
    boolean unicode;

    public PieceDescriptor(byte[] buf, int offset) {
        this.descriptor = LittleEndian.getShort((byte[])buf, (int)offset);
        this.fc = LittleEndian.getInt((byte[])buf, (int)(offset += 2));
        this.prm = LittleEndian.getShort((byte[])buf, (int)(offset += 4));
        if ((this.fc & 0x40000000) == 0) {
            this.unicode = true;
        } else {
            this.unicode = false;
            this.fc &= 0xBFFFFFFF;
            this.fc /= 2;
        }
    }

    public int getFilePosition() {
        return this.fc;
    }

    public void setFilePosition(int pos) {
        this.fc = pos;
    }

    public boolean isUnicode() {
        return this.unicode;
    }

    protected byte[] toByteArray() {
        int tempFc = this.fc;
        if (!this.unicode) {
            tempFc *= 2;
            tempFc |= 0x40000000;
        }
        int offset = 0;
        byte[] buf = new byte[8];
        LittleEndian.putShort((byte[])buf, (int)offset, (short)this.descriptor);
        LittleEndian.putInt((byte[])buf, (int)(offset += 2), (int)tempFc);
        LittleEndian.putShort((byte[])buf, (int)(offset += 4), (short)this.prm);
        return buf;
    }

    public static int getSizeInBytes() {
        return 8;
    }

    public boolean equals(Object o) {
        PieceDescriptor pd = (PieceDescriptor)o;
        return this.descriptor == pd.descriptor && this.prm == pd.prm && this.unicode == pd.unicode;
    }
}

