/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.odf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.IOUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.odf.OpenDocumentContentParser;
import org.apache.tika.parser.odf.OpenDocumentMetaParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenDocumentParser
implements Parser {
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application((String)"vnd.sun.xml.writer"), MediaType.application((String)"vnd.oasis.opendocument.text"), MediaType.application((String)"vnd.oasis.opendocument.graphics"), MediaType.application((String)"vnd.oasis.opendocument.presentation"), MediaType.application((String)"vnd.oasis.opendocument.spreadsheet"), MediaType.application((String)"vnd.oasis.opendocument.chart"), MediaType.application((String)"vnd.oasis.opendocument.image"), MediaType.application((String)"vnd.oasis.opendocument.formula"), MediaType.application((String)"vnd.oasis.opendocument.text-master"), MediaType.application((String)"vnd.oasis.opendocument.text-web"), MediaType.application((String)"vnd.oasis.opendocument.text-template"), MediaType.application((String)"vnd.oasis.opendocument.graphics-template"), MediaType.application((String)"vnd.oasis.opendocument.presentation-template"), MediaType.application((String)"vnd.oasis.opendocument.spreadsheet-template"), MediaType.application((String)"vnd.oasis.opendocument.chart-template"), MediaType.application((String)"vnd.oasis.opendocument.image-template"), MediaType.application((String)"vnd.oasis.opendocument.formula-template"), MediaType.application((String)"x-vnd.oasis.opendocument.text"), MediaType.application((String)"x-vnd.oasis.opendocument.graphics"), MediaType.application((String)"x-vnd.oasis.opendocument.presentation"), MediaType.application((String)"x-vnd.oasis.opendocument.spreadsheet"), MediaType.application((String)"x-vnd.oasis.opendocument.chart"), MediaType.application((String)"x-vnd.oasis.opendocument.image"), MediaType.application((String)"x-vnd.oasis.opendocument.formula"), MediaType.application((String)"x-vnd.oasis.opendocument.text-master"), MediaType.application((String)"x-vnd.oasis.opendocument.text-web"), MediaType.application((String)"x-vnd.oasis.opendocument.text-template"), MediaType.application((String)"x-vnd.oasis.opendocument.graphics-template"), MediaType.application((String)"x-vnd.oasis.opendocument.presentation-template"), MediaType.application((String)"x-vnd.oasis.opendocument.spreadsheet-template"), MediaType.application((String)"x-vnd.oasis.opendocument.chart-template"), MediaType.application((String)"x-vnd.oasis.opendocument.image-template"), MediaType.application((String)"x-vnd.oasis.opendocument.formula-template"))));
    private Parser meta = new OpenDocumentMetaParser();
    private Parser content = new OpenDocumentContentParser();

    public Parser getMetaParser() {
        return this.meta;
    }

    public void setMetaParser(Parser meta) {
        this.meta = meta;
    }

    public Parser getContentParser() {
        return this.content;
    }

    public void setContentParser(Parser content) {
        this.content = content;
    }

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        ZipInputStream zip = new ZipInputStream(stream);
        ZipEntry entry = zip.getNextEntry();
        while (entry != null) {
            if (entry.getName().equals("mimetype")) {
                String type = IOUtils.toString((InputStream)zip, (String)"UTF-8");
                metadata.set("Content-Type", type);
            } else if (entry.getName().equals("meta.xml")) {
                this.meta.parse((InputStream)zip, (ContentHandler)new DefaultHandler(), metadata, context);
            } else if (entry.getName().endsWith("content.xml")) {
                this.content.parse((InputStream)zip, handler, metadata, context);
            }
            entry = zip.getNextEntry();
        }
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }
}

