/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.transaction.impl.jboss;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.transaction.xa.Xid;
import org.exoplatform.services.transaction.ExoResource;
import org.exoplatform.services.transaction.TransactionService;

public class JBossTransactionService
implements TransactionService {
    private volatile TransactionManager tm;

    public TransactionManager getTransactionManager() {
        if (this.tm == null) {
            try {
                this.tm = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            }
            catch (NamingException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.tm;
    }

    public UserTransaction getUserTransaction() {
        try {
            return (UserTransaction)new InitialContext().lookup("java:/TransactionManager");
        }
        catch (NamingException e) {
            throw new IllegalStateException(e);
        }
    }

    public int getDefaultTimeout() {
        try {
            MBeanServer server = MBeanServerFactory.findMBeanServer(null).iterator().next();
            return (Integer)server.getAttribute(ObjectName.getInstance("jboss:service=TransactionManager"), "TransactionTimeout");
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        TransactionManager tm = this.getTransactionManager();
        tm.setTransactionTimeout(seconds);
    }

    public void enlistResource(ExoResource exores) throws RollbackException, SystemException {
        TransactionManager tm = this.getTransactionManager();
        Transaction tx = tm.getTransaction();
        tx.enlistResource(exores.getXAResource());
    }

    public void delistResource(ExoResource exores) throws RollbackException, SystemException {
        TransactionManager tm = this.getTransactionManager();
        Transaction tx = tm.getTransaction();
        tx.delistResource(exores.getXAResource(), 0);
    }

    public Xid createXid() {
        throw new UnsupportedOperationException("Only used by JCR impl in tests");
    }
}

