/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Annotations;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ErrorsException;
import com.google.inject.internal.ImmutableList;
import com.google.inject.internal.ImmutableSet;
import com.google.inject.internal.Lists;
import com.google.inject.internal.MoreTypes;
import com.google.inject.internal.Nullability;
import com.google.inject.spi.Dependency;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InjectionPoint {
    private final boolean optional;
    private final Member member;
    private final ImmutableList<Dependency<?>> dependencies;

    private InjectionPoint(Member member, ImmutableList<Dependency<?>> dependencies, boolean optional) {
        this.member = member;
        this.dependencies = dependencies;
        this.optional = optional;
    }

    InjectionPoint(TypeLiteral<?> type, Method method) {
        this.member = method;
        Inject inject = method.getAnnotation(Inject.class);
        this.optional = inject.optional();
        this.dependencies = this.forMember(method, type, method.getParameterAnnotations());
    }

    InjectionPoint(TypeLiteral<?> type, Constructor<?> constructor) {
        this.member = constructor;
        this.optional = false;
        this.dependencies = this.forMember(constructor, type, constructor.getParameterAnnotations());
    }

    InjectionPoint(TypeLiteral<?> type, Field field) {
        this.member = field;
        Inject inject = field.getAnnotation(Inject.class);
        this.optional = inject.optional();
        Annotation[] annotations = field.getAnnotations();
        Errors errors = new Errors(field);
        Key<?> key = null;
        try {
            key = Annotations.getKey(type.getFieldType(field), field, annotations, errors);
        }
        catch (ErrorsException e) {
            errors.merge(e.getErrors());
        }
        errors.throwConfigurationExceptionIfErrorsExist();
        this.dependencies = ImmutableList.of(this.newDependency(key, Nullability.allowsNull(annotations), -1));
    }

    private ImmutableList<Dependency<?>> forMember(Member member, TypeLiteral<?> type, Annotation[][] paramterAnnotations) {
        Errors errors = new Errors(member);
        Iterator annotationsIterator = Arrays.asList(paramterAnnotations).iterator();
        ArrayList<Dependency<?>> dependencies = Lists.newArrayList();
        int index = 0;
        for (TypeLiteral<?> parameterType : type.getParameterTypes(member)) {
            try {
                Annotation[] parameterAnnotations = (Annotation[])annotationsIterator.next();
                Key<?> key = Annotations.getKey(parameterType, member, parameterAnnotations, errors);
                dependencies.add(this.newDependency(key, Nullability.allowsNull(parameterAnnotations), index));
                ++index;
            }
            catch (ErrorsException e) {
                errors.merge(e.getErrors());
            }
        }
        errors.throwConfigurationExceptionIfErrorsExist();
        return ImmutableList.copyOf(dependencies);
    }

    private <T> Dependency<T> newDependency(Key<T> key, boolean allowsNull, int parameterIndex) {
        return new Dependency<T>(this, key, allowsNull, parameterIndex);
    }

    public Member getMember() {
        return this.member;
    }

    public List<Dependency<?>> getDependencies() {
        return this.dependencies;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean equals(Object o) {
        return o instanceof InjectionPoint && this.member.equals(((InjectionPoint)o).member);
    }

    public int hashCode() {
        return this.member.hashCode();
    }

    public String toString() {
        return MoreTypes.toString(this.member);
    }

    public static InjectionPoint forConstructorOf(TypeLiteral<?> type) {
        Class<?> rawType = MoreTypes.getRawType(type.getType());
        Errors errors = new Errors(rawType);
        Constructor<?> injectableConstructor = null;
        for (Constructor<?> constructor : rawType.getDeclaredConstructors()) {
            Inject inject = constructor.getAnnotation(Inject.class);
            if (inject == null) continue;
            if (inject.optional()) {
                errors.optionalConstructor(constructor);
            }
            if (injectableConstructor != null) {
                errors.tooManyConstructors(rawType);
            }
            injectableConstructor = constructor;
            InjectionPoint.checkForMisplacedBindingAnnotations(injectableConstructor, errors);
        }
        errors.throwConfigurationExceptionIfErrorsExist();
        if (injectableConstructor != null) {
            return new InjectionPoint(type, injectableConstructor);
        }
        try {
            Constructor<?> noArgConstructor = rawType.getDeclaredConstructor(new Class[0]);
            if (Modifier.isPrivate(noArgConstructor.getModifiers()) && !Modifier.isPrivate(rawType.getModifiers())) {
                errors.missingConstructor(rawType);
                throw new ConfigurationException(errors.getMessages());
            }
            InjectionPoint.checkForMisplacedBindingAnnotations(noArgConstructor, errors);
            return new InjectionPoint(type, noArgConstructor);
        }
        catch (NoSuchMethodException e) {
            errors.missingConstructor(rawType);
            throw new ConfigurationException(errors.getMessages());
        }
    }

    public static InjectionPoint forConstructorOf(Class<?> type) {
        return InjectionPoint.forConstructorOf(TypeLiteral.get(type));
    }

    public static Set<InjectionPoint> forStaticMethodsAndFields(TypeLiteral type) {
        ArrayList<InjectionPoint> sink = Lists.newArrayList();
        Errors errors = new Errors();
        InjectionPoint.addInjectionPoints(type, Factory.FIELDS, true, sink, errors);
        InjectionPoint.addInjectionPoints(type, Factory.METHODS, true, sink, errors);
        ImmutableSet<InjectionPoint> result = ImmutableSet.copyOf(sink);
        if (errors.hasErrors()) {
            throw new ConfigurationException(errors.getMessages()).withPartialValue(result);
        }
        return result;
    }

    public static Set<InjectionPoint> forStaticMethodsAndFields(Class<?> type) {
        return InjectionPoint.forStaticMethodsAndFields(TypeLiteral.get(type));
    }

    public static Set<InjectionPoint> forInstanceMethodsAndFields(TypeLiteral<?> type) {
        ArrayList<InjectionPoint> sink = Lists.newArrayList();
        Errors errors = new Errors();
        InjectionPoint.addInjectionPoints(type, Factory.FIELDS, false, sink, errors);
        InjectionPoint.addInjectionPoints(type, Factory.METHODS, false, sink, errors);
        ImmutableSet<InjectionPoint> result = ImmutableSet.copyOf(sink);
        if (errors.hasErrors()) {
            throw new ConfigurationException(errors.getMessages()).withPartialValue(result);
        }
        return result;
    }

    public static Set<InjectionPoint> forInstanceMethodsAndFields(Class<?> type) {
        return InjectionPoint.forInstanceMethodsAndFields(TypeLiteral.get(type));
    }

    private static void checkForMisplacedBindingAnnotations(Member member, Errors errors) {
        Annotation misplacedBindingAnnotation = Annotations.findBindingAnnotation(errors, member, ((AnnotatedElement)((Object)member)).getAnnotations());
        if (misplacedBindingAnnotation == null) {
            return;
        }
        if (member instanceof Method) {
            try {
                if (member.getDeclaringClass().getDeclaredField(member.getName()) != null) {
                    return;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        errors.misplacedBindingAnnotation(member, misplacedBindingAnnotation);
    }

    private static <M extends Member & AnnotatedElement> void addInjectionPoints(TypeLiteral<?> type, Factory<M> factory, boolean statics, Collection<InjectionPoint> injectionPoints, Errors errors) {
        if (type.getType() == Object.class) {
            return;
        }
        TypeLiteral<?> superType = type.getSupertype(type.getRawType().getSuperclass());
        InjectionPoint.addInjectionPoints(superType, factory, statics, injectionPoints, errors);
        InjectionPoint.addInjectorsForMembers(type, factory, statics, injectionPoints, errors);
    }

    private static <M extends Member & AnnotatedElement> void addInjectorsForMembers(TypeLiteral<?> typeLiteral, Factory<M> factory, boolean statics, Collection<InjectionPoint> injectionPoints, Errors errors) {
        for (Member member : factory.getMembers(MoreTypes.getRawType(typeLiteral.getType()))) {
            Inject inject;
            if (InjectionPoint.isStatic(member) != statics || (inject = ((AnnotatedElement)((Object)member)).getAnnotation(Inject.class)) == null) continue;
            try {
                injectionPoints.add(factory.create(typeLiteral, member, errors));
            }
            catch (ConfigurationException ignorable) {
                if (inject.optional()) continue;
                errors.merge(ignorable.getErrorMessages());
            }
        }
    }

    private static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Factory<M extends Member & AnnotatedElement> {
        public static final Factory<Field> FIELDS = new Factory<Field>(){

            public Field[] getMembers(Class<?> type) {
                return type.getDeclaredFields();
            }

            @Override
            public InjectionPoint create(TypeLiteral<?> typeLiteral, Field member, Errors errors) {
                return new InjectionPoint(typeLiteral, member);
            }
        };
        public static final Factory<Method> METHODS = new Factory<Method>(){

            public Method[] getMembers(Class<?> type) {
                return type.getDeclaredMethods();
            }

            @Override
            public InjectionPoint create(TypeLiteral<?> typeLiteral, Method member, Errors errors) {
                InjectionPoint.checkForMisplacedBindingAnnotations(member, errors);
                return new InjectionPoint(typeLiteral, member);
            }
        };

        public M[] getMembers(Class<?> var1);

        public InjectionPoint create(TypeLiteral<?> var1, M var2, Errors var3);
    }
}

