/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.logging.Log;
import org.jgroups.Address;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelListener;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.TimeoutException;
import org.jgroups.Transport;
import org.jgroups.UpHandler;
import org.jgroups.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Channel
implements Transport {
    public static final int BLOCK = 0;
    public static final int VIEW = 1;
    public static final int SUSPECT = 2;
    public static final int LOCAL = 3;
    public static final int GET_STATE_EVENTS = 4;
    public static final int AUTO_RECONNECT = 5;
    public static final int AUTO_GETSTATE = 6;
    protected UpHandler up_handler = null;
    protected Set<ChannelListener> channel_listeners = null;
    protected Receiver receiver = null;

    protected abstract Log getLog();

    public abstract void connect(String var1) throws ChannelException;

    public abstract void connect(String var1, Address var2, String var3, long var4) throws ChannelException;

    public abstract void disconnect();

    public abstract void close();

    public abstract void shutdown();

    public void open() throws ChannelException {
    }

    public abstract boolean isOpen();

    public abstract boolean isConnected();

    public int getNumMessages() {
        return -1;
    }

    public String dumpQueue() {
        return "";
    }

    public abstract Map dumpStats();

    @Override
    public abstract void send(Message var1) throws ChannelNotConnectedException, ChannelClosedException;

    public abstract void send(Address var1, Address var2, Serializable var3) throws ChannelNotConnectedException, ChannelClosedException;

    public void down(Event evt) {
    }

    public Object downcall(Event evt) {
        return null;
    }

    @Override
    public abstract Object receive(long var1) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException;

    public abstract Object peek(long var1) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException;

    public abstract View getView();

    public abstract Address getLocalAddress();

    public abstract String getChannelName();

    public abstract String getClusterName();

    public void setUpHandler(UpHandler up_handler) {
        this.up_handler = up_handler;
    }

    public void setChannelListener(ChannelListener channel_listener) {
        this.addChannelListener(channel_listener);
    }

    public synchronized void addChannelListener(ChannelListener listener) {
        if (listener == null) {
            return;
        }
        if (this.channel_listeners == null) {
            this.channel_listeners = new CopyOnWriteArraySet<ChannelListener>();
        }
        this.channel_listeners.add(listener);
    }

    public synchronized void removeChannelListener(ChannelListener listener) {
        if (this.channel_listeners != null && listener != null) {
            this.channel_listeners.remove(listener);
        }
    }

    public synchronized void clearChannelListeners() {
        if (this.channel_listeners != null) {
            this.channel_listeners.clear();
        }
    }

    public void setReceiver(Receiver r) {
        this.receiver = r;
    }

    public abstract void setOpt(int var1, Object var2);

    public abstract Object getOpt(int var1);

    public abstract boolean flushSupported();

    public abstract boolean startFlush(List<Address> var1, boolean var2);

    public abstract boolean startFlush(boolean var1);

    public abstract boolean startFlush(long var1, boolean var3);

    public abstract void stopFlush();

    public abstract void stopFlush(List<Address> var1);

    public abstract void blockOk();

    public abstract boolean getState(Address var1, long var2) throws ChannelNotConnectedException, ChannelClosedException;

    public abstract boolean getState(Address var1, String var2, long var3) throws ChannelNotConnectedException, ChannelClosedException;

    public abstract boolean getAllStates(Vector var1, long var2) throws ChannelNotConnectedException, ChannelClosedException;

    public abstract void returnState(byte[] var1);

    public abstract void returnState(byte[] var1, String var2);

    public abstract Map<String, Object> getInfo();

    public abstract void setInfo(String var1, Object var2);

    public static String option2String(int option) {
        switch (option) {
            case 0: {
                return "BLOCK";
            }
            case 1: {
                return "VIEW";
            }
            case 2: {
                return "SUSPECT";
            }
            case 3: {
                return "LOCAL";
            }
            case 4: {
                return "GET_STATE_EVENTS";
            }
            case 5: {
                return "AUTO_RECONNECT";
            }
            case 6: {
                return "AUTO_GETSTATE";
            }
        }
        return "unknown (" + option + ')';
    }

    protected void notifyChannelConnected(Channel c) {
        if (this.channel_listeners == null) {
            return;
        }
        for (ChannelListener channelListener : this.channel_listeners) {
            try {
                channelListener.channelConnected(c);
            }
            catch (Throwable t) {
                this.getLog().error((Object)"exception in channelConnected() callback", t);
            }
        }
    }

    protected void notifyChannelDisconnected(Channel c) {
        if (this.channel_listeners == null) {
            return;
        }
        for (ChannelListener channelListener : this.channel_listeners) {
            try {
                channelListener.channelDisconnected(c);
            }
            catch (Throwable t) {
                this.getLog().error((Object)"exception in channelDisonnected() callback", t);
            }
        }
    }

    protected void notifyChannelClosed(Channel c) {
        if (this.channel_listeners == null) {
            return;
        }
        for (ChannelListener channelListener : this.channel_listeners) {
            try {
                channelListener.channelClosed(c);
            }
            catch (Throwable t) {
                this.getLog().error((Object)"exception in channelClosed() callback", t);
            }
        }
    }

    protected void notifyChannelShunned() {
        if (this.channel_listeners == null) {
            return;
        }
        for (ChannelListener channelListener : this.channel_listeners) {
            try {
                channelListener.channelShunned();
            }
            catch (Throwable t) {
                this.getLog().error((Object)"exception in channelShunned() callback", t);
            }
        }
    }

    protected void notifyChannelReconnected(Address addr) {
        if (this.channel_listeners == null) {
            return;
        }
        for (ChannelListener channelListener : this.channel_listeners) {
            try {
                channelListener.channelReconnected(addr);
            }
            catch (Throwable t) {
                this.getLog().error((Object)"exception in channelReconnected() callback", t);
            }
        }
    }
}

