/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Value;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.ecm.publication.NotInPublicationLifecycleException;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationConstant;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.config.VersionLog;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/wcm/webui/publication/lifecycle/stageversion/ui/UIPublicationHistory.gtmpl", events={@EventConfig(listeners={CloseActionListener.class})})
public class UIPublicationHistory
extends UIComponentDecorator {
    private UIPageIterator uiPageIterator_ = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "PublicationLogListIterator");
    private NodeLocation currentNodeLocation;

    public UIPublicationHistory() throws Exception {
        this.setUIComponent((UIComponent)this.uiPageIterator_);
    }

    public void init(Node node) {
        this.currentNodeLocation = NodeLocation.make((Node)node);
    }

    public List<VersionLog> getLog() throws NotInPublicationLifecycleException, Exception {
        Value[] values;
        if (this.currentNodeLocation == null) {
            return new ArrayList<VersionLog>();
        }
        ArrayList<VersionLog> logs = new ArrayList<VersionLog>();
        Node currentNode_ = NodeLocation.getNodeByLocation((NodeLocation)this.currentNodeLocation);
        for (Value value : values = currentNode_.getProperty(StageAndVersionPublicationConstant.HISTORY).getValues()) {
            String logString = value.getString();
            VersionLog bean = VersionLog.toVersionLog(logString);
            logs.add(bean);
        }
        return logs;
    }

    public void updateGrid() throws Exception {
        ObjectPageList objPageList = new ObjectPageList(this.getLog(), 10);
        this.uiPageIterator_.setPageList((PageList)objPageList);
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public List getLogList() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public String[] getActions() {
        return new String[]{"Close"};
    }

    public class HistoryBean {
        private String date;
        private String newState;
        private String user;
        private String description;

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getNewState() {
            return this.newState;
        }

        public void setNewState(String newState) {
            this.newState = newState;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String formatStringByDateTime(String stringInput) {
            String dateYear = stringInput.substring(0, 4);
            String dateMonth = stringInput.substring(4, 6);
            String dateDay = stringInput.substring(6, 8);
            String dateHour = stringInput.substring(9, 11);
            String dateMinute = stringInput.substring(11, 13);
            String dateSecond = stringInput.substring(13, 15);
            StringBuilder builder = new StringBuilder();
            builder.append(dateMonth).append("/").append(dateDay).append("/").append(dateYear).append(" ").append(dateHour).append(":").append(dateMinute).append(":").append(dateSecond);
            return builder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIPublicationHistory> {
        public void execute(Event<UIPublicationHistory> event) throws Exception {
            UIPublicationHistory uiPublicationLogList = (UIPublicationHistory)((Object)event.getSource());
            UIPopupContainer uiPopupContainer = (UIPopupContainer)uiPublicationLogList.getAncestorOfType(UIPopupContainer.class);
            uiPopupContainer.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupContainer);
        }
    }
}

