/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.info;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.namespace.QName;
import org.gatein.common.i18n.LocaleFormat;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.common.i18n.ResourceBundleManager;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.common.reflect.NoSuchClassException;
import org.gatein.common.util.ConversionException;
import org.gatein.pc.api.LifeCyclePhase;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.info.RuntimeOptionInfo;
import org.gatein.pc.portlet.impl.info.ContainerCacheInfo;
import org.gatein.pc.portlet.impl.info.ContainerCapabilitiesInfo;
import org.gatein.pc.portlet.impl.info.ContainerEventInfo;
import org.gatein.pc.portlet.impl.info.ContainerEventingInfo;
import org.gatein.pc.portlet.impl.info.ContainerFilterInfo;
import org.gatein.pc.portlet.impl.info.ContainerInfoBuilderContext;
import org.gatein.pc.portlet.impl.info.ContainerListenerInfo;
import org.gatein.pc.portlet.impl.info.ContainerMetaInfo;
import org.gatein.pc.portlet.impl.info.ContainerModeInfo;
import org.gatein.pc.portlet.impl.info.ContainerNavigationInfo;
import org.gatein.pc.portlet.impl.info.ContainerParameterInfo;
import org.gatein.pc.portlet.impl.info.ContainerPortletApplicationInfo;
import org.gatein.pc.portlet.impl.info.ContainerPortletInfo;
import org.gatein.pc.portlet.impl.info.ContainerPortletManagedModeInfo;
import org.gatein.pc.portlet.impl.info.ContainerPreferencesInfo;
import org.gatein.pc.portlet.impl.info.ContainerRuntimeOptionInfo;
import org.gatein.pc.portlet.impl.info.ContainerSecurityInfo;
import org.gatein.pc.portlet.impl.info.ContainerTypeInfo;
import org.gatein.pc.portlet.impl.info.ContainerUserInfo;
import org.gatein.pc.portlet.impl.info.ContainerWindowStateInfo;
import org.gatein.pc.portlet.impl.metadata.CustomPortletModeMetaData;
import org.gatein.pc.portlet.impl.metadata.CustomWindowStateMetaData;
import org.gatein.pc.portlet.impl.metadata.ListenerMetaData;
import org.gatein.pc.portlet.impl.metadata.PortletApplication10MetaData;
import org.gatein.pc.portlet.impl.metadata.PortletApplication20MetaData;
import org.gatein.pc.portlet.impl.metadata.PublicRenderParameterMetaData;
import org.gatein.pc.portlet.impl.metadata.UserAttributeMetaData;
import org.gatein.pc.portlet.impl.metadata.common.ContainerRuntimeMetaData;
import org.gatein.pc.portlet.impl.metadata.common.InitParamMetaData;
import org.gatein.pc.portlet.impl.metadata.event.EventDefinitionMetaData;
import org.gatein.pc.portlet.impl.metadata.event.EventDefinitionReferenceMetaData;
import org.gatein.pc.portlet.impl.metadata.filter.FilterMappingMetaData;
import org.gatein.pc.portlet.impl.metadata.filter.FilterMetaData;
import org.gatein.pc.portlet.impl.metadata.portlet.PortletInfoMetaData;
import org.gatein.pc.portlet.impl.metadata.portlet.PortletMetaData;
import org.gatein.pc.portlet.impl.metadata.portlet.PortletModeMetaData;
import org.gatein.pc.portlet.impl.metadata.portlet.PortletPreferenceMetaData;
import org.gatein.pc.portlet.impl.metadata.portlet.PortletPreferencesMetaData;
import org.gatein.pc.portlet.impl.metadata.portlet.SecurityRoleRefMetaData;
import org.gatein.pc.portlet.impl.metadata.portlet.SupportedLocaleMetaData;
import org.gatein.pc.portlet.impl.metadata.portlet.SupportsMetaData;
import org.gatein.pc.portlet.impl.metadata.portlet.WindowStateMetaData;
import org.gatein.pc.portlet.impl.metadata.security.SecurityConstraintMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerInfoBuilder {
    private static final String[] KEYS = new String[]{"title", "short-title", "keywords"};
    private static final String JAVAX_PORTLET = "javax.portlet.";
    private static final String[] BUNDLE_KEYS = new String[]{"javax.portlet.title", "javax.portlet.short-title", "javax.portlet.keywords"};
    private static final List<ListenerMetaData> EMPTY_LISTENER_LIST = Collections.emptyList();
    private static final List<PublicRenderParameterMetaData> EMPTY_PUBLIC_RENDER_PARAMETER_LIST = Collections.emptyList();
    private static final List<EventDefinitionMetaData> EMPTY_EVENT_DEFINITION_LIST = Collections.emptyList();
    private static final List<SecurityRoleRefMetaData> EMPPTY_SECURITY_ROLE_REF_LIST = Collections.emptyList();
    private static final List<SecurityConstraintMetaData> EMPTY_SECURITY_CONSTRAINT_LIST = Collections.emptyList();
    private static final List<SupportedLocaleMetaData> EMPTY_SUPPORTED_LOCALE_LIST = Collections.emptyList();
    private static final List<PortletModeMetaData> EMPTY_PORTLET_MODE_LIST = Collections.emptyList();
    private static final List<WindowStateMetaData> EMPTY_WINDOW_STATE_LIST = Collections.emptyList();
    private static final Map<String, PortletPreferenceMetaData> EMPTY_PORTLET_PREFERENCE_MAP = Collections.emptyMap();
    private static final PortletPreferencesMetaData EMPTY_PORTLET_PREFERENCES = new PortletPreferencesMetaData();
    private static final List<InitParamMetaData> EMPTY_INIT_PARAM_LIST = Collections.emptyList();
    private static final List<String> EMPTY_STRING_LIST = Collections.emptyList();
    private static final List<EventDefinitionReferenceMetaData> EMPTY_EVENT_DEFINITION_REFERENCE_LIST = Collections.emptyList();
    private static final List<FilterMappingMetaData> EMPTY_FILTER_MAPPING_LIST = Collections.emptyList();
    private static final Map<String, FilterMetaData> EMPTY_FILTER_MAP = Collections.emptyMap();
    private static final Map<String, ContainerRuntimeMetaData> EMPTY_CONTAINER_RUNTIME_OPTION_MAP = Collections.emptyMap();
    private static final Map<String, CustomPortletModeMetaData> EMPTY_CUSTOM_PORTLET_MODES = Collections.emptyMap();
    private static final Map<String, CustomWindowStateMetaData> EMPTY_CUSTOM_WINDOW_STATES = Collections.emptyMap();
    private final PortletApplication10MetaData portletApplicationMD;
    private final ContainerInfoBuilderContext context;
    private final Map<QName, ContainerEventInfo> events;
    private final Map<String, ContainerParameterInfo> publicParameters;
    private ContainerPortletApplicationInfo portletApplication;
    private final String portletApplicationId;
    private final Map<String, ContainerPortletInfo> portlets;
    private final Map<String, RuntimeOptionInfo> applicationOptions;
    private final Map<Mode, ContainerModeInfo> customModes;
    private final Map<WindowState, ContainerWindowStateInfo> customWindowStates;
    private final Logger log = LoggerFactory.getLogger(ContainerInfoBuilder.class);

    public ContainerInfoBuilder(String portletApplicationId, PortletApplication10MetaData portletApplicationMD, ContainerInfoBuilderContext context) {
        this.portletApplicationId = portletApplicationId;
        this.portletApplicationMD = portletApplicationMD;
        this.context = context;
        this.events = new LinkedHashMap<QName, ContainerEventInfo>();
        this.publicParameters = new LinkedHashMap<String, ContainerParameterInfo>();
        this.portlets = new LinkedHashMap<String, ContainerPortletInfo>();
        this.applicationOptions = new HashMap<String, RuntimeOptionInfo>();
        this.customModes = new HashMap<Mode, ContainerModeInfo>();
        this.customWindowStates = new HashMap<WindowState, ContainerWindowStateInfo>();
    }

    public ContainerPortletApplicationInfo getApplication() {
        return this.portletApplication;
    }

    public Collection<ContainerPortletInfo> getPortlets() {
        return this.portlets.values();
    }

    private void fixMetaData(PortletApplication10MetaData portletApplicationMD) {
        if (portletApplicationMD instanceof PortletApplication20MetaData) {
            PortletApplication20MetaData tmp = (PortletApplication20MetaData)portletApplicationMD;
            if (tmp.getEvents() == null) {
                tmp.setEvents(EMPTY_EVENT_DEFINITION_LIST);
            }
            if (tmp.getPublicRenderParameters() == null) {
                tmp.setPublicRenderParameters(EMPTY_PUBLIC_RENDER_PARAMETER_LIST);
            }
            if (tmp.getDefaultNamespace() == null) {
                try {
                    tmp.setDefaultNamespace(new URI(""));
                }
                catch (URISyntaxException e) {
                    throw new Error(e);
                }
            }
            if (tmp.getListeners() == null) {
                tmp.setListeners(EMPTY_LISTENER_LIST);
            }
            if (tmp.getFilters() == null) {
                tmp.setFilters(EMPTY_FILTER_MAP);
            }
            for (FilterMetaData filterMD : tmp.getFilters().values()) {
                if (filterMD.getInitParams() != null) continue;
                filterMD.setInitParams(EMPTY_INIT_PARAM_LIST);
            }
            if (tmp.getFilterMapping() == null) {
                tmp.setFilterMapping(EMPTY_FILTER_MAPPING_LIST);
            }
            if (tmp.getContainerRuntimeOptions() == null) {
                tmp.setContainerRuntimeOptions(EMPTY_CONTAINER_RUNTIME_OPTION_MAP);
            }
        }
        if (portletApplicationMD.getCustomPortletModes() == null) {
            portletApplicationMD.setCustomPortletModes(EMPTY_CUSTOM_PORTLET_MODES);
        }
        if (portletApplicationMD.getCustomWindowStates() == null) {
            portletApplicationMD.setCustomWindowStates(EMPTY_CUSTOM_WINDOW_STATES);
        }
    }

    private void fixMetaData(PortletMetaData portletMD) {
        if (portletMD.getSecurityRoleRef() == null) {
            portletMD.setSecurityRoleRef(EMPPTY_SECURITY_ROLE_REF_LIST);
        }
        if (portletMD.getPortletApplication().getSecurityConstraints() == null) {
            portletMD.getPortletApplication().setSecurityConstraints(EMPTY_SECURITY_CONSTRAINT_LIST);
        }
        if (portletMD.getSupportedLocale() == null) {
            portletMD.setSupportedLocale(EMPTY_SUPPORTED_LOCALE_LIST);
        }
        for (SupportsMetaData supportsMD : portletMD.getSupports()) {
            if (supportsMD.getPortletModes() == null) {
                supportsMD.setPortletModes(EMPTY_PORTLET_MODE_LIST);
            }
            if (supportsMD.getWindowStates() != null) continue;
            supportsMD.setWindowStates(EMPTY_WINDOW_STATE_LIST);
        }
        if (portletMD.getPortletPreferences() == null) {
            portletMD.setPortletPreferences(EMPTY_PORTLET_PREFERENCES);
        }
        if (portletMD.getPortletPreferences().getPortletPreferences() == null) {
            portletMD.getPortletPreferences().setPortletPreferences(EMPTY_PORTLET_PREFERENCE_MAP);
        }
        if (portletMD.getInitParams() == null) {
            portletMD.setInitParams(EMPTY_INIT_PARAM_LIST);
        }
        if (portletMD.getSupportedPublicRenderParameters() == null) {
            portletMD.setSupportedPublicRenderParameters(EMPTY_STRING_LIST);
        }
        for (PortletPreferenceMetaData portletPreferenceMD : portletMD.getPortletPreferences().getPortletPreferences().values()) {
            if (portletPreferenceMD.getValue() != null) continue;
            portletPreferenceMD.setValue(EMPTY_STRING_LIST);
        }
        if (this.portletApplicationMD instanceof PortletApplication20MetaData) {
            if (portletMD.getSupportedProcessingEvent() == null) {
                portletMD.setSupportedProcessingEvent(EMPTY_EVENT_DEFINITION_REFERENCE_LIST);
            }
            if (portletMD.getSupportedPublishingEvent() == null) {
                portletMD.setSupportedPublishingEvent(EMPTY_EVENT_DEFINITION_REFERENCE_LIST);
            }
            if (portletMD.getContainerRuntimeOptions() == null) {
                portletMD.setContainerRuntimeOptions(EMPTY_CONTAINER_RUNTIME_OPTION_MAP);
            }
        }
    }

    private QName getName(QName name, String localPart) {
        if (name == null) {
            String namespaceURI = ((PortletApplication20MetaData)this.portletApplicationMD).getDefaultNamespace().toString();
            return new QName(namespaceURI, localPart);
        }
        return name;
    }

    private List<Locale> getSupportedLocales(PortletMetaData portletMD) {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (SupportedLocaleMetaData supportedLocaleMD : portletMD.getSupportedLocale()) {
            try {
                Locale locale = LocaleFormat.DEFAULT.getLocale(supportedLocaleMD.getLocale());
                locales.add(locale);
            }
            catch (ConversionException e) {
                this.log.error((Object)("Could not convert supported locale (" + supportedLocaleMD.getLocale() + ") for portlet: " + portletMD.getPortletName()), (Throwable)e);
            }
        }
        return locales;
    }

    public void build() {
        this.portletApplication = this.build(this.portletApplicationMD);
        for (PortletMetaData portletMD : this.portletApplicationMD.getPortletCollection()) {
            ContainerPortletInfo portlet = this.build(portletMD);
            this.portlets.put(portlet.getName(), portlet);
        }
    }

    private ContainerPortletApplicationInfo build(PortletApplication10MetaData portletApplicationMD) {
        LocalizedString description;
        Map<String, UserAttributeMetaData> userAttributesMD;
        this.fixMetaData(portletApplicationMD);
        String defaultNamespace = "";
        List<ContainerListenerInfo> listeners = Collections.emptyList();
        HashMap<String, ContainerFilterInfo> allFilters = new HashMap<String, ContainerFilterInfo>();
        if (this.portletApplicationMD instanceof PortletApplication20MetaData) {
            PortletApplication20MetaData tmp = (PortletApplication20MetaData)this.portletApplicationMD;
            defaultNamespace = tmp.getDefaultNamespace() != null ? tmp.getDefaultNamespace().toString() : null;
            for (EventDefinitionMetaData eventDefinitionMD : tmp.getEvents()) {
                try {
                    ContainerEventInfo event = this.build(eventDefinitionMD);
                    this.events.put(event.getName(), event);
                }
                catch (NoSuchClassException e) {
                    this.log.error((Object)("Cannot load event class " + e.getClassName()), (Throwable)e);
                }
            }
            for (PublicRenderParameterMetaData parameterMD : tmp.getPublicRenderParameters()) {
                ContainerParameterInfo parameter = this.build(parameterMD);
                this.publicParameters.put(parameter.getId(), parameter);
            }
            Map<String, RuntimeOptionInfo> applicationOptions = this.build(tmp.getContainerRuntimeOptions().values());
            if (applicationOptions != null) {
                this.applicationOptions.putAll(applicationOptions);
            }
            listeners = new ArrayList(tmp.getListeners().size());
            for (ListenerMetaData listenerMD : tmp.getListeners()) {
                ContainerListenerInfo containerListenerInfo = this.build(listenerMD);
                listeners.add(containerListenerInfo);
            }
            listeners = Collections.unmodifiableList(listeners);
            for (FilterMetaData filterMD : tmp.getFilterCollection()) {
                ContainerFilterInfo containerFilterInfo = this.build(filterMD);
                allFilters.put(containerFilterInfo.getName(), containerFilterInfo);
            }
        }
        Set<String> supportedUserAttributes = (userAttributesMD = portletApplicationMD.getUserAttributes()) != null ? Collections.unmodifiableSet(userAttributesMD.keySet()) : Collections.emptySet();
        ContainerUserInfo user = new ContainerUserInfo(supportedUserAttributes);
        for (CustomPortletModeMetaData customPortletModeMetaData : portletApplicationMD.getCustomPortletModes().values()) {
            ContainerModeInfo modeInfo;
            Mode mode = Mode.create((String)customPortletModeMetaData.getPortletMode());
            description = customPortletModeMetaData.getDescription();
            if (customPortletModeMetaData.isPortalManaged()) {
                modeInfo = description != null ? new ContainerModeInfo(mode, description) : new ContainerModeInfo(mode);
            } else {
                ResourceBundleManager bundleMgr = this.context.getBundleManager();
                LocalizedString displayName = bundleMgr.getLocalizedValue("javax.portlet.app.custom-portlet-mode." + mode + ".decoration-name", "" + mode);
                modeInfo = description != null ? new ContainerPortletManagedModeInfo(mode, description, displayName) : new ContainerPortletManagedModeInfo(mode, displayName);
            }
            this.customModes.put(mode, modeInfo);
        }
        for (CustomWindowStateMetaData customWindowStateMetaData : portletApplicationMD.getCustomWindowStates().values()) {
            WindowState windowState = WindowState.create((String)customWindowStateMetaData.getWindowState());
            description = customWindowStateMetaData.getDescription();
            ContainerWindowStateInfo windowStateInfo = description != null ? new ContainerWindowStateInfo(windowState, description) : new ContainerWindowStateInfo(windowState);
            this.customWindowStates.put(windowState, windowStateInfo);
        }
        return new ContainerPortletApplicationInfo(this.portletApplicationId, defaultNamespace, allFilters.values(), listeners, user);
    }

    private ContainerListenerInfo build(ListenerMetaData listenerMD) {
        return new ContainerListenerInfo(listenerMD.getListenerClass(), listenerMD.getDisplayName(), listenerMD.getDescription());
    }

    private ContainerFilterInfo build(FilterMetaData filterMD) {
        HashMap<String, String> initParameters = new HashMap<String, String>();
        for (InitParamMetaData initParamMD : filterMD.getInitParams()) {
            initParameters.put(initParamMD.getName(), initParamMD.getValue());
        }
        return new ContainerFilterInfo(filterMD.getFilterName(), filterMD.getFilterClass(), Collections.unmodifiableSet(new HashSet<LifeCyclePhase>(filterMD.getLifecycle())), filterMD.getDisplayName(), filterMD.getDescription(), Collections.unmodifiableMap(initParameters));
    }

    private ContainerParameterInfo build(PublicRenderParameterMetaData parameterMD) {
        QName name = this.getName(parameterMD.getQname(), parameterMD.getName());
        ResourceBundleManager bundleMgr = this.context.getBundleManager();
        LocalizedString description = bundleMgr.getLocalizedValue("javax.portlet.app.public-render-parameter." + name + ".description", this.getDefaultStringFor(parameterMD.getDescription(), "Description of public render parameter " + name));
        return new ContainerParameterInfo(parameterMD.getIdentifier(), name, parameterMD.getAlias(), description);
    }

    private String getDefaultStringFor(LocalizedString desc, String defaultValue) {
        return desc != null ? desc.getDefaultString() : defaultValue;
    }

    private ContainerEventInfo build(EventDefinitionMetaData eventDefinitionMD) throws NoSuchClassException {
        QName name = this.getName(eventDefinitionMD.getQname(), eventDefinitionMD.getName());
        ResourceBundleManager bundleMgr = this.context.getBundleManager();
        String valueType = eventDefinitionMD.getValueType();
        ContainerTypeInfo type = null;
        if (valueType != null) {
            Class clazz = this.context.getClass(valueType);
            type = new ContainerTypeInfo(clazz);
        }
        LocalizedString displayName = bundleMgr.getLocalizedValue("javax.portlet.app.event-definition." + name + ".display-name", "Event " + name);
        LocalizedString description = bundleMgr.getLocalizedValue("javax.portlet.app.event-definition." + name + ".description", this.getDefaultStringFor(eventDefinitionMD.getDescription(), "Description of event " + name));
        return new ContainerEventInfo(name, type, displayName, description, eventDefinitionMD.getAlias());
    }

    private ContainerPortletInfo build(PortletMetaData portletMD) {
        ContainerPortletInfo containerPortletInfo;
        this.fixMetaData(portletMD);
        ContainerCapabilitiesInfo containerCapabilities = this.buildContainerCapabilities(portletMD);
        ContainerPreferencesInfo containerPreferences = this.buildContainerPreferences(portletMD);
        ContainerMetaInfo containerMeta = this.buildContainerMeta(portletMD);
        ContainerSecurityInfo containerSecurity = this.buildContainerSecurityInfo(portletMD);
        ContainerCacheInfo containerCache = this.buildContainerCache(portletMD);
        Map<String, String> initParameters = Collections.emptyMap();
        for (InitParamMetaData initParamMD : portletMD.getInitParams()) {
            if (initParameters.isEmpty()) {
                initParameters = new HashMap();
            }
            initParameters.put(initParamMD.getName(), initParamMD.getValue());
        }
        if (initParameters.size() > 0) {
            initParameters = Collections.unmodifiableMap(initParameters);
        }
        if (this.portletApplicationMD instanceof PortletApplication20MetaData) {
            Map<String, RuntimeOptionInfo> options;
            ContainerEventingInfo containerEvents = this.buildContainerEventsInfo(portletMD);
            ContainerNavigationInfo containerNavigation = this.buildContainerNavigationInfo(portletMD);
            List<String> filters = Collections.emptyList();
            for (FilterMappingMetaData filterMappingMD : ((PortletApplication20MetaData)this.portletApplicationMD).getFilterMapping()) {
                for (String portletName : filterMappingMD.getPortletNames()) {
                    boolean matches;
                    if (portletName.length() == 0) {
                        matches = false;
                    } else if (portletName.endsWith("*")) {
                        String prefix = portletName.substring(0, portletName.length() - 1);
                        matches = portletMD.getPortletName().startsWith(prefix);
                    } else {
                        matches = portletMD.getPortletName().equals(portletName);
                    }
                    if (!matches) continue;
                    if (filters.isEmpty()) {
                        filters = new ArrayList();
                    }
                    filters.add(filterMappingMD.getName());
                }
            }
            if (filters.size() > 0) {
                filters = Collections.unmodifiableList(filters);
            }
            if ((options = this.build(portletMD.getContainerRuntimeOptions().values())) != null) {
                for (Map.Entry<String, RuntimeOptionInfo> entry : this.applicationOptions.entrySet()) {
                    if (options.containsKey(entry.getKey())) continue;
                    options.put(entry.getKey(), entry.getValue());
                }
                options = Collections.unmodifiableMap(options);
            } else {
                options = this.applicationOptions;
            }
            containerPortletInfo = new ContainerPortletInfo(containerCapabilities, containerPreferences, containerMeta, containerSecurity, containerCache, containerEvents, containerNavigation, filters, portletMD.getPortletName(), this.context.getApplicationName(), portletMD.getPortletClass(), initParameters, null, this.context.getBundleManager(portletMD), options);
        } else {
            containerPortletInfo = new ContainerPortletInfo(containerCapabilities, containerPreferences, containerMeta, containerSecurity, containerCache, portletMD.getPortletName(), portletMD.getPortletClass(), this.context.getApplicationName(), Collections.unmodifiableMap(initParameters), this.context.getBundleManager(portletMD));
        }
        return containerPortletInfo;
    }

    private Map<String, RuntimeOptionInfo> build(Collection<ContainerRuntimeMetaData> optionsMD) {
        HashMap<String, ContainerRuntimeOptionInfo> options = null;
        for (ContainerRuntimeMetaData containerRuntimeMD : optionsMD) {
            ContainerRuntimeOptionInfo optionInfo = this.build(containerRuntimeMD);
            if (options == null) {
                options = new HashMap<String, ContainerRuntimeOptionInfo>();
            }
            options.put(optionInfo.getName(), optionInfo);
        }
        return options;
    }

    private ContainerRuntimeOptionInfo build(ContainerRuntimeMetaData containerRuntimeMD) {
        return new ContainerRuntimeOptionInfo(containerRuntimeMD.getName(), Collections.unmodifiableList(containerRuntimeMD.getValues()));
    }

    private ContainerNavigationInfo buildContainerNavigationInfo(PortletMetaData portletMD) {
        ContainerNavigationInfo navigation = new ContainerNavigationInfo();
        for (String parameterId : portletMD.getSupportedPublicRenderParameters()) {
            ContainerParameterInfo parameter = this.publicParameters.get(parameterId);
            if (parameter == null) continue;
            navigation.addPublicParameter(parameter);
        }
        return navigation;
    }

    private ContainerEventingInfo buildContainerEventsInfo(PortletMetaData portletMD) {
        ContainerEventInfo event;
        QName name;
        ContainerEventingInfo portletEvents = new ContainerEventingInfo();
        for (EventDefinitionReferenceMetaData eventDefinitionReferenceMD : portletMD.getSupportedProcessingEvent()) {
            name = this.getName(eventDefinitionReferenceMD.getQname(), eventDefinitionReferenceMD.getName());
            event = this.events.get(name);
            if (event != null) {
                portletEvents.addConsumedEvent(event);
                continue;
            }
            this.log.error((Object)("Portlet " + portletMD.getPortletName() + " references the event " + name + " that is not " + "declared at the application level"));
        }
        for (EventDefinitionReferenceMetaData eventDefinitionReferenceMD : portletMD.getSupportedPublishingEvent()) {
            name = this.getName(eventDefinitionReferenceMD.getQname(), eventDefinitionReferenceMD.getName());
            event = this.events.get(name);
            if (event != null) {
                portletEvents.addProducedEvent(event);
                continue;
            }
            this.log.error((Object)("Portlet " + portletMD.getPortletName() + " references the event " + name + " that is not " + "declared at the application level"));
        }
        return portletEvents;
    }

    private ContainerSecurityInfo buildContainerSecurityInfo(PortletMetaData portletMD) {
        ContainerSecurityInfo containerSecurity = new ContainerSecurityInfo();
        for (SecurityRoleRefMetaData securityRoleRefMD : portletMD.getSecurityRoleRef()) {
            containerSecurity.addRoleRef(securityRoleRefMD.getRoleName(), securityRoleRefMD.getRoleLink());
        }
        for (SecurityConstraintMetaData securityConstraintMD : portletMD.getPortletApplication().getSecurityConstraints()) {
            if (!securityConstraintMD.getPortletList().getPortletNames().contains(portletMD.getPortletName())) continue;
            containerSecurity.addTransportGuarantee(securityConstraintMD.getUserDataConstraint().getTransportGuarantee());
        }
        return containerSecurity;
    }

    private ContainerCacheInfo buildContainerCache(PortletMetaData portletMD) {
        int expirationCache = portletMD.getExpirationCache();
        if (expirationCache < 0 && expirationCache != -1) {
            expirationCache = 0;
        }
        return new ContainerCacheInfo(expirationCache);
    }

    private ContainerCapabilitiesInfo buildContainerCapabilities(PortletMetaData portletMD) {
        ContainerCapabilitiesInfo capabilities = new ContainerCapabilitiesInfo();
        for (SupportedLocaleMetaData supportedLocaleMD : portletMD.getSupportedLocale()) {
            try {
                capabilities.addLocale(LocaleFormat.DEFAULT.getLocale(supportedLocaleMD.getLocale()));
            }
            catch (ConversionException e) {
                this.log.error((Object)("Could not convert supported locale (" + supportedLocaleMD.getLocale() + ") for portlet: " + portletMD.getPortletName()), (Throwable)e);
            }
        }
        for (SupportsMetaData supportsMD : portletMD.getSupports()) {
            String mimeType = supportsMD.getMimeType().toLowerCase();
            capabilities.add(mimeType, Mode.VIEW);
            for (PortletModeMetaData modeMD : supportsMD.getPortletModes()) {
                ContainerModeInfo mode = this.customModes.get(modeMD.getPortletMode());
                if (mode != null) {
                    capabilities.add(mimeType, mode);
                    continue;
                }
                capabilities.add(mimeType, modeMD.getPortletMode());
            }
            for (WindowStateMetaData windowStateMD : supportsMD.getWindowStates()) {
                ContainerWindowStateInfo windowStateInfo = this.customWindowStates.get(windowStateMD.getWindowState());
                if (windowStateInfo != null) {
                    capabilities.add(mimeType, windowStateInfo);
                    continue;
                }
                capabilities.add(mimeType, windowStateMD.getWindowState());
            }
            capabilities.add(mimeType, WindowState.NORMAL);
            capabilities.add(mimeType, WindowState.MINIMIZED);
            capabilities.add(mimeType, WindowState.MAXIMIZED);
        }
        return capabilities;
    }

    private ContainerMetaInfo buildContainerMeta(PortletMetaData portletMD) {
        ContainerMetaInfo containerMeta = new ContainerMetaInfo();
        ResourceBundleManager bundleMgr = this.context.getBundleManager(portletMD);
        PortletInfoMetaData portletInfoMD = portletMD.getPortletInfo();
        String[] inlines = null;
        if (portletInfoMD != null) {
            String title = portletInfoMD.getTitle();
            if (title == null) {
                title = "";
            }
            inlines = new String[]{title, portletInfoMD.getShortTitle(), portletInfoMD.getKeywords()};
        }
        for (int i = 0; i < KEYS.length; ++i) {
            String key = KEYS[i];
            HashMap<Locale, String> tmp = new HashMap<Locale, String>();
            List<Locale> locales = this.getSupportedLocales(portletMD);
            locales.add(Locale.ENGLISH);
            for (Locale locale : locales) {
                ResourceBundle bundle = bundleMgr.getResourceBundle(locale);
                if (bundle == null) continue;
                try {
                    String value = bundle.getString(BUNDLE_KEYS[i]);
                    tmp.put(locale, value);
                }
                catch (MissingResourceException ignore) {}
            }
            if (inlines != null && inlines[i] != null) {
                tmp.put(Locale.ENGLISH, inlines[i]);
            }
            LocalizedString ls = new LocalizedString(tmp, Locale.ENGLISH);
            containerMeta.addMetaValue(key, ls);
        }
        containerMeta.addMetaValue("description", portletMD.getDescription());
        containerMeta.addMetaValue("display-name", portletMD.getDisplayName());
        return containerMeta;
    }

    private ContainerPreferencesInfo buildContainerPreferences(PortletMetaData portletMD) {
        PortletPreferencesMetaData preferencesMD = portletMD.getPortletPreferences();
        ContainerPreferencesInfo containerPreferences = null;
        if (preferencesMD != null) {
            containerPreferences = new ContainerPreferencesInfo(preferencesMD.getPreferenceValidator());
            ResourceBundleManager bundleMgr = this.context.getBundleManager(portletMD);
            for (PortletPreferenceMetaData portletPreferenceMD : preferencesMD.getPortletPreferences().values()) {
                List<String> value = portletPreferenceMD.getValue();
                LocalizedString displayName = bundleMgr.getLocalizedValue("javax.portlet.preference.name." + portletPreferenceMD.getName(), portletPreferenceMD.getName());
                LocalizedString description = bundleMgr.getLocalizedValue("javax.portlet.preference.description." + portletPreferenceMD.getName(), portletPreferenceMD.getName());
                containerPreferences.addContainerPreference(portletPreferenceMD.getName(), value, portletPreferenceMD.isReadOnly(), displayName, description);
            }
        }
        return containerPreferences;
    }
}

