/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.configuration;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.configuration.AbstractObjectInfo;
import org.jbpm.configuration.ConfigurationException;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.ObjectInfo;
import org.jbpm.context.exe.Converter;
import org.jbpm.context.exe.JbpmType;
import org.jbpm.context.exe.JbpmTypeMatcher;
import org.jbpm.context.exe.VariableInstance;
import org.jbpm.db.hibernate.Converters;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class JbpmTypeObjectInfo
extends AbstractObjectInfo {
    private static final long serialVersionUID = 1L;
    ObjectInfo typeMatcherObjectInfo = null;
    Converter converter = null;
    Class variableInstanceClass = null;
    private static Log log = LogFactory.getLog((Class)JbpmTypeObjectInfo.class);

    public JbpmTypeObjectInfo(Element jbpmTypeElement, ObjectFactoryParser objectFactoryParser) {
        super(jbpmTypeElement, objectFactoryParser);
        try {
            Element variableInstanceElement;
            Element typeMatcherElement = XmlUtil.element(jbpmTypeElement, "matcher");
            if (typeMatcherElement == null) {
                throw new ConfigurationException("matcher is a required element in a jbpm-type: " + XmlUtil.toString(jbpmTypeElement));
            }
            Element typeMatcherBeanElement = XmlUtil.element(typeMatcherElement);
            this.typeMatcherObjectInfo = objectFactoryParser.parse(typeMatcherBeanElement);
            Element converterElement = XmlUtil.element(jbpmTypeElement, "converter");
            if (converterElement != null) {
                if (!converterElement.hasAttribute("class")) {
                    throw new ConfigurationException("class attribute is required in a converter element: " + XmlUtil.toString(jbpmTypeElement));
                }
                String converterClassName = converterElement.getAttribute("class");
                this.converter = Converters.getConverterByClassName(converterClassName);
            }
            if (!(variableInstanceElement = XmlUtil.element(jbpmTypeElement, "variable-instance")).hasAttribute("class")) {
                throw new ConfigurationException("class is a required attribute in element variable-instance: " + XmlUtil.toString(jbpmTypeElement));
            }
            String variableInstanceClassName = variableInstanceElement.getAttribute("class");
            this.variableInstanceClass = ClassLoaderUtil.classForName(variableInstanceClassName);
            if (!VariableInstance.class.isAssignableFrom(this.variableInstanceClass)) {
                throw new ConfigurationException("variable instance class '" + variableInstanceClassName + "' is not a VariableInstance");
            }
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.debug((Object)("jbpm variables type " + XmlUtil.toString(jbpmTypeElement) + " couldn't be instantiated properly: " + e.toString()));
            this.typeMatcherObjectInfo = new ObjectInfo(){
                private static final long serialVersionUID = 1L;

                public boolean hasName() {
                    return false;
                }

                public String getName() {
                    return null;
                }

                public boolean isSingleton() {
                    return true;
                }

                public Object createObject(ObjectFactoryImpl objectFactory) {
                    return new JbpmTypeMatcher(){
                        private static final long serialVersionUID = 1L;

                        public boolean matches(Object value) {
                            return false;
                        }
                    };
                }
            };
            this.converter = null;
            this.variableInstanceClass = null;
        }
    }

    public Object createObject(ObjectFactoryImpl objectFactory) {
        JbpmTypeMatcher jbpmTypeMatcher = (JbpmTypeMatcher)objectFactory.createObject(this.typeMatcherObjectInfo);
        return new JbpmType(jbpmTypeMatcher, this.converter, this.variableInstanceClass);
    }
}

