/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.jbpm.db.JbpmSession;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.logging.log.ProcessLog;
import org.jbpm.persistence.JbpmPersistenceException;

public class LoggingSession {
    final Session session;
    final JbpmSession jbpmSession;
    private static final Log log = LogFactory.getLog((Class)LoggingSession.class);

    public LoggingSession(JbpmSession jbpmSession) {
        this.session = jbpmSession.getSession();
        this.jbpmSession = jbpmSession;
    }

    public LoggingSession(Session session) {
        this.session = session;
        this.jbpmSession = null;
    }

    public Map findLogsByProcessInstance(long processInstanceId) {
        HashMap tokenLogs = new HashMap();
        try {
            ProcessInstance processInstance = (ProcessInstance)this.session.load(ProcessInstance.class, (Serializable)new Long(processInstanceId));
            this.collectTokenLogs(tokenLogs, processInstance.getRootToken());
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("couldn't get logs for process instance " + processInstanceId, e);
        }
        return tokenLogs;
    }

    private void collectTokenLogs(Map tokenLogs, Token token) {
        tokenLogs.put(token, this.findLogsByToken(token.getId()));
        Map children = token.getChildren();
        if (children != null) {
            Iterator i = children.values().iterator();
            while (i.hasNext()) {
                Token child = (Token)i.next();
                this.collectTokenLogs(tokenLogs, child);
            }
        }
    }

    public List findLogsByToken(long tokenId) {
        try {
            Token token = (Token)this.session.load(Token.class, (Serializable)new Long(tokenId));
            return this.session.getNamedQuery("LoggingSession.findLogsByToken").setEntity("token", (Object)token).list();
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("couldn't get logs for token '" + tokenId + "'", e);
        }
    }

    public void saveProcessLog(ProcessLog processLog) {
        try {
            this.session.save((Object)processLog);
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("couldn't save process log '" + processLog + "'", e);
        }
    }

    public ProcessLog loadProcessLog(long processLogId) {
        ProcessLog processLog = null;
        try {
            processLog = (ProcessLog)this.session.load(ProcessLog.class, (Serializable)new Long(processLogId));
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("couldn't load process log '" + processLogId + "'", e);
        }
        return processLog;
    }

    public ProcessLog getProcessLog(long processLogId) {
        ProcessLog processLog = null;
        try {
            processLog = (ProcessLog)this.session.get(ProcessLog.class, (Serializable)new Long(processLogId));
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("couldn't get process log '" + processLogId + "'", e);
        }
        return processLog;
    }

    private void handle(HibernateException exception) {
        log.debug((Object)exception);
        if (this.jbpmSession != null) {
            this.jbpmSession.handleException();
        }
    }
}

