/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

public class UIPortalActionListener {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PingActionListener
    extends EventListener<UIPortal> {
        public void execute(Event<UIPortal> event) throws Exception {
            PortalRequestContext pContext = (PortalRequestContext)event.getRequestContext();
            HttpServletRequest request = pContext.getRequest();
            pContext.setFullRender(false);
            pContext.setResponseComplete(true);
            pContext.getWriter().write("" + request.getSession().getMaxInactiveInterval());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeWindowStateActionListener
    extends EventListener<UIPortal> {
        public void execute(Event<UIPortal> event) throws Exception {
            UIPortal uiPortal = (UIPortal)((Object)event.getSource());
            String portletId = event.getRequestContext().getRequestParameter("portletId");
            UIPortlet uiPortlet = (UIPortlet)uiPortal.findComponentById(portletId);
            WebuiRequestContext context = event.getRequestContext();
            uiPortlet.createEvent("ChangeWindowState", event.getExecutionPhase(), context).broadcast();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LogoutActionListener
    extends EventListener<UIComponent> {
        public void execute(Event<UIComponent> event) throws Exception {
            PortalRequestContext prContext = Util.getPortalRequestContext();
            prContext.getRequest().getSession().invalidate();
            HttpServletRequest request = prContext.getRequest();
            String portalName = URLEncoder.encode(Util.getUIPortal().getName(), "UTF-8");
            String redirect = request.getContextPath() + "/public/" + portalName + "/";
            prContext.getResponse().sendRedirect(redirect);
            prContext.setResponseComplete(true);
        }
    }
}

