/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.repository;

import org.exoplatform.ecm.webui.component.admin.repository.UIPermissionContainer;
import org.exoplatform.ecm.webui.component.admin.repository.UIWizardStep1;
import org.exoplatform.ecm.webui.component.admin.repository.UIWorkspaceWizard;
import org.exoplatform.ecm.webui.component.admin.repository.UIWorkspaceWizardContainer;
import org.exoplatform.ecm.webui.selector.UIPermissionSelector;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class})})
public class UIWorkspacePermissionForm
extends UIForm
implements UISelectable {
    public static final String FIELD_PERMISSION = "permission";

    public UIWorkspacePermissionForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_PERMISSION, FIELD_PERMISSION, null).addValidator(MandatoryValidator.class, new Object[0]).setEditable(false));
        for (String perm : PermissionType.ALL) {
            this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(perm, perm, null));
        }
    }

    protected boolean isCheckedAny() {
        for (String perm : PermissionType.ALL) {
            if (!this.getUIFormCheckBoxInput(perm).isChecked()) continue;
            return true;
        }
        return false;
    }

    public void doSelect(String selectField, Object value) {
        this.getUIStringInput(FIELD_PERMISSION).setValue((Object)value.toString());
        this.checkAll(false);
    }

    public void reset() {
        this.getUIStringInput(FIELD_PERMISSION).setValue(null);
        this.checkAll(false);
    }

    private void checkAll(boolean check) {
        for (String perm : PermissionType.ALL) {
            this.getUIFormCheckBoxInput(perm).setChecked(check);
        }
    }

    protected void lockForm(boolean lock) {
        boolean editable = !lock;
        UIPermissionContainer uiContainer = (UIPermissionContainer)this.getAncestorOfType(UIPermissionContainer.class);
        ((UIPermissionSelector)uiContainer.getChild(UIPermissionSelector.class)).setRendered(editable);
        this.getUIStringInput(FIELD_PERMISSION).setEditable(false);
        for (String perm : PermissionType.ALL) {
            this.getUIFormCheckBoxInput(perm).setEnable(editable);
        }
        if (!editable) {
            this.setActions(new String[]{"Cancel"});
        } else {
            this.setActions(new String[]{"Save", "Cancel"});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIWorkspacePermissionForm> {
        public void execute(Event<UIWorkspacePermissionForm> event) throws Exception {
            UIPopupContainer uiPopup = (UIPopupContainer)((UIWorkspacePermissionForm)((Object)event.getSource())).getAncestorOfType(UIPopupContainer.class);
            uiPopup.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIWorkspacePermissionForm> {
        public void execute(Event<UIWorkspacePermissionForm> event) throws Exception {
            UIWorkspacePermissionForm uiForm = (UIWorkspacePermissionForm)((Object)event.getSource());
            UIWorkspaceWizardContainer uiWizardContainer = (UIWorkspaceWizardContainer)uiForm.getAncestorOfType(UIWorkspaceWizardContainer.class);
            UIWorkspaceWizard uiWizardForm = (UIWorkspaceWizard)uiWizardContainer.getChild(UIWorkspaceWizard.class);
            String user = (String)uiForm.getUIStringInput(UIWorkspacePermissionForm.FIELD_PERMISSION).getValue();
            if (!uiForm.isCheckedAny()) {
                UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIWorkspacePermissionForm.msg.check-one", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            StringBuilder sb = new StringBuilder();
            for (String perm : PermissionType.ALL) {
                if (!uiForm.getUIFormCheckBoxInput(perm).isChecked()) continue;
                sb.append(user + " " + perm + ";");
            }
            if (uiForm.getUIFormCheckBoxInput("add_node").isChecked() || uiForm.getUIFormCheckBoxInput("remove").isChecked() || uiForm.getUIFormCheckBoxInput("set_property").isChecked()) {
                String readperm = user + " " + "read" + ";";
                if (!sb.toString().contains(readperm)) {
                    sb.append(readperm);
                }
            }
            UIWizardStep1 ws1 = (UIWizardStep1)uiWizardForm.getChildById("step1");
            ws1.addPermissions(user, sb.toString());
            ws1.refreshPermissionList();
            UIPopupContainer uiPopup = (UIPopupContainer)uiForm.getAncestorOfType(UIPopupContainer.class);
            uiPopup.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWizardForm);
        }
    }
}

