/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyManagerTrees;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeContainer;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.taxonomy.TaxonomyTreeData;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/admin/taxonomy/UITaxonomyTreeList.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UITaxonomyTreeList.msg.confirm-delete"), @EventConfig(listeners={EditTaxonomyTreeActionListener.class}), @EventConfig(listeners={AddTaxonomyTreeActionListener.class})})
public class UITaxonomyTreeList
extends UIComponentDecorator {
    public static final String[] ACTIONS = new String[]{"AddTaxonomyTree"};
    public static final String ST_ADD = "AddTaxonomyTreePopup";
    public static final String ST_EDIT = "EditTaxonomyTreePopup";
    public static final String ACCESS_PERMISSION = "exo:accessPermissions";
    private UIPageIterator uiPageIterator_ = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UITaxonomyTreeListIterator");

    public UITaxonomyTreeList() throws Exception {
        this.setUIComponent((UIComponent)this.uiPageIterator_);
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public List getTaxonomyTreeList() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public void updateTaxonomyTreeListGrid(int currentPage) throws Exception {
        ObjectPageList objPageList = new ObjectPageList(this.getAllTaxonomyTreeList(), 10);
        this.uiPageIterator_.setPageList((PageList)objPageList);
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.uiPageIterator_.setCurrentPage(currentPage - 1);
        } else {
            this.uiPageIterator_.setCurrentPage(currentPage);
        }
    }

    private List<TaxonomyTreeData> getAllTaxonomyTreeList() throws RepositoryException {
        ArrayList<TaxonomyTreeData> lstTaxonomyTreeData = new ArrayList<TaxonomyTreeData>();
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        List lstTaxonomyTreeNode = taxonomyService.getAllTaxonomyTrees(repository);
        if (lstTaxonomyTreeNode != null && lstTaxonomyTreeNode.size() > 0) {
            for (Node node : lstTaxonomyTreeNode) {
                lstTaxonomyTreeData.add(this.setData(node));
            }
        }
        return lstTaxonomyTreeData;
    }

    private TaxonomyTreeData setData(Node node) {
        TaxonomyTreeData taxonomyTreeData;
        block6: {
            taxonomyTreeData = null;
            TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
            String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
            try {
                if (node == null) break block6;
                taxonomyTreeData = new TaxonomyTreeData();
                taxonomyTreeData.setTaxoTreeName(node.getName());
                taxonomyTreeData.setTaxoTreeHomePath(node.getPath());
                taxonomyTreeData.setTaxoTreeWorkspace(node.getSession().getWorkspace().getName());
                Node realTreeNode = taxonomyService.getTaxonomyTree(repository, node.getName(), true);
                Value[] values = realTreeNode.getProperty("exo:permissions").getValues();
                StringBuffer buffer = new StringBuffer(1024);
                try {
                    for (Value permission : values) {
                        buffer.append(permission.getString()).append(';');
                    }
                }
                catch (ValueFormatException e) {
                }
                catch (RepositoryException e) {
                    // empty catch block
                }
                String permission = buffer.toString();
                taxonomyTreeData.setTaxoTreePermissions(permission.substring(0, permission.length() - 1));
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
        return taxonomyTreeData;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditTaxonomyTreeActionListener
    extends EventListener<UITaxonomyTreeList> {
        public void execute(Event<UITaxonomyTreeList> event) throws Exception {
            UITaxonomyManagerTrees uiTaxonomyManagerTrees = (UITaxonomyManagerTrees)((UITaxonomyTreeList)((Object)event.getSource())).getParent();
            uiTaxonomyManagerTrees.removeChildById(UITaxonomyTreeList.ST_ADD);
            uiTaxonomyManagerTrees.initPopupTreeContainer(UITaxonomyTreeList.ST_EDIT);
            UITaxonomyTreeContainer uiTaxoTreeContainer = (UITaxonomyTreeContainer)uiTaxonomyManagerTrees.findFirstComponentOfType(UITaxonomyTreeContainer.class);
            String taxoTreeName = event.getRequestContext().getRequestParameter("objectId");
            String repository = ((UIECMAdminPortlet)uiTaxonomyManagerTrees.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
            TaxonomyTreeData taxoTreeData = new TaxonomyTreeData();
            taxoTreeData.setTaxoTreeName(taxoTreeName);
            taxoTreeData.setEdit(true);
            taxoTreeData.setRepository(repository);
            uiTaxoTreeContainer.setTaxonomyTreeData(taxoTreeData);
            uiTaxoTreeContainer.refresh();
            uiTaxoTreeContainer.viewStep(4);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyManagerTrees);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddTaxonomyTreeActionListener
    extends EventListener<UITaxonomyTreeList> {
        public void execute(Event<UITaxonomyTreeList> event) throws Exception {
            UITaxonomyManagerTrees uiTaxonomyManagerTrees = (UITaxonomyManagerTrees)((UITaxonomyTreeList)((Object)event.getSource())).getParent();
            uiTaxonomyManagerTrees.removeChildById(UITaxonomyTreeList.ST_EDIT);
            uiTaxonomyManagerTrees.initPopupTreeContainer(UITaxonomyTreeList.ST_ADD);
            UITaxonomyTreeContainer uiForm = (UITaxonomyTreeContainer)uiTaxonomyManagerTrees.findFirstComponentOfType(UITaxonomyTreeContainer.class);
            uiForm.refresh();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyManagerTrees);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UITaxonomyTreeList> {
        public void execute(Event<UITaxonomyTreeList> event) throws Exception {
            UITaxonomyTreeList uiTaxonomyTreeList = (UITaxonomyTreeList)((Object)event.getSource());
            UITaxonomyManagerTrees uiTaxonomyManagerTrees = (UITaxonomyManagerTrees)uiTaxonomyTreeList.getParent();
            String taxoTreeName = event.getRequestContext().getRequestParameter("objectId");
            String repository = ((UIECMAdminPortlet)uiTaxonomyTreeList.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
            TaxonomyService taxonomyService = (TaxonomyService)uiTaxonomyTreeList.getApplicationComponent(TaxonomyService.class);
            ActionServiceContainer actionService = (ActionServiceContainer)uiTaxonomyTreeList.getApplicationComponent(ActionServiceContainer.class);
            UIApplication uiApp = (UIApplication)uiTaxonomyTreeList.getAncestorOfType(UIApplication.class);
            try {
                Node taxonomyTreeNode = taxonomyService.getTaxonomyTree(repository, taxoTreeName, true);
                actionService.removeAction(taxonomyTreeNode, repository);
                taxonomyService.removeTaxonomyTree(taxoTreeName);
            }
            catch (RepositoryException e) {
                uiApp.addMessage(new ApplicationMessage("UITaxonomyTreeList.msg.remove-exception", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            uiTaxonomyManagerTrees.update();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyManagerTrees);
        }
    }
}

