/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy.info;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import org.exoplatform.ecm.permission.info.UIPermissionInputSet;
import org.exoplatform.ecm.webui.component.admin.taxonomy.info.UIPermissionInfo;
import org.exoplatform.ecm.webui.component.admin.taxonomy.info.UIPermissionManager;
import org.exoplatform.ecm.webui.selector.UIGroupMemberSelector;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ResetActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CloseActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectUserActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectMemberActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={AddAnyActionListener.class})})
public class UIPermissionForm
extends UIForm
implements UISelectable {
    public static final String PERMISSION = "permission";
    public static final String POPUP_SELECT = "SelectUserOrGroup";
    public static final String SELECT_GROUP_ID = "TaxoSelectUserOrGroup";
    private static final Log LOG = ExoLogger.getLogger((String)"admin.UIPermissionForm");
    private Node currentNode;

    public UIPermissionForm() throws Exception {
        this.addChild((UIComponent)new UIPermissionInputSet(PERMISSION));
        this.setActions(new String[]{"Save", "Reset", "Close"});
    }

    private void refresh() {
        this.reset();
        this.checkAll(false);
    }

    private void checkAll(boolean check) {
        UIPermissionInputSet uiInputSet = (UIPermissionInputSet)this.getChildById(PERMISSION);
        for (String perm : PermissionType.ALL) {
            uiInputSet.getUIFormCheckBoxInput(perm).setChecked(check);
        }
    }

    protected boolean isEditable(Node node) throws Exception {
        return PermissionUtil.canChangePermission((Node)node);
    }

    public void fillForm(String user, ExtendedNode node) throws Exception {
        UIPermissionInputSet uiInputSet = (UIPermissionInputSet)this.getChildById(PERMISSION);
        this.refresh();
        uiInputSet.getUIStringInput("userOrGroup").setValue((Object)user);
        if (user.equals(Utils.getNodeOwner((Node)node))) {
            for (String perm : PermissionType.ALL) {
                uiInputSet.getUIFormCheckBoxInput(perm).setChecked(true);
            }
        } else {
            List permsList = node.getACL().getPermissionEntries();
            Iterator perIter = permsList.iterator();
            StringBuilder userPermission = new StringBuilder();
            while (perIter.hasNext()) {
                AccessControlEntry accessControlEntry = (AccessControlEntry)perIter.next();
                if (!user.equals(accessControlEntry.getIdentity())) continue;
                userPermission.append(accessControlEntry.getPermission()).append(" ");
            }
            for (String perm : PermissionType.ALL) {
                boolean isCheck = userPermission.toString().contains(perm);
                uiInputSet.getUIFormCheckBoxInput(perm).setChecked(isCheck);
            }
        }
    }

    protected void lockForm(boolean isLock) {
        UIPermissionInputSet uiInputSet = (UIPermissionInputSet)this.getChildById(PERMISSION);
        if (isLock) {
            this.setActions(new String[]{"Reset", "Close"});
            uiInputSet.setActionInfo("userOrGroup", null);
        } else {
            this.setActions(new String[]{"Save", "Reset", "Close"});
            uiInputSet.setActionInfo("userOrGroup", new String[]{"SelectUser", "SelectMember", "AddAny"});
        }
        for (String perm : PermissionType.ALL) {
            uiInputSet.getUIFormCheckBoxInput(perm).setEnable(!isLock);
        }
    }

    private String getExoOwner(Node node) throws Exception {
        return Utils.getNodeOwner((Node)node);
    }

    public void doSelect(String selectField, Object value) {
        try {
            ExtendedNode node = (ExtendedNode)this.getCurrentNode();
            this.checkAll(false);
            this.fillForm(value.toString(), node);
            this.lockForm(value.toString().equals(this.getExoOwner((Node)node)));
            this.getUIStringInput(selectField).setValue((Object)value.toString());
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
        }
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(Node currentNode) {
        this.currentNode = currentNode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIPermissionForm> {
        public void execute(Event<UIPermissionForm> event) throws Exception {
            UIPopupContainer uiPopupContainer = (UIPopupContainer)((UIPermissionForm)((Object)event.getSource())).getAncestorOfType(UIPopupContainer.class);
            uiPopupContainer.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupContainer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectMemberActionListener
    extends EventListener<UIPermissionForm> {
        public void execute(Event<UIPermissionForm> event) throws Exception {
            UIPermissionForm uiForm = (UIPermissionForm)((Object)event.getSource());
            UIGroupMemberSelector uiGroupMemberSelector = (UIGroupMemberSelector)uiForm.createUIComponent(UIGroupMemberSelector.class, null, UIPermissionForm.SELECT_GROUP_ID);
            uiGroupMemberSelector.setSourceComponent((UIComponent)uiForm, new String[]{"userOrGroup"});
            ((UIPermissionManager)uiForm.getAncestorOfType(UIPermissionManager.class)).initPopupPermission((UIComponent)uiGroupMemberSelector);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddAnyActionListener
    extends EventListener<UIPermissionForm> {
        public void execute(Event<UIPermissionForm> event) throws Exception {
            UIPermissionForm uiForm = (UIPermissionForm)((Object)event.getSource());
            UIPermissionInputSet uiInputSet = (UIPermissionInputSet)uiForm.getChildById(UIPermissionForm.PERMISSION);
            uiInputSet.getUIStringInput("userOrGroup").setValue((Object)SystemIdentity.ANY);
            uiForm.checkAll(false);
            uiInputSet.getUIFormCheckBoxInput("read").setChecked(true);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectUserActionListener
    extends EventListener<UIPermissionForm> {
        public void execute(Event<UIPermissionForm> event) throws Exception {
            UIPermissionForm uiForm = (UIPermissionForm)((Object)event.getSource());
            ((UIPermissionManager)uiForm.getParent()).initUserSelector();
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIPermissionForm> {
        public void execute(Event<UIPermissionForm> event) throws Exception {
            String lockToken;
            UIPermissionForm uiForm = (UIPermissionForm)((Object)event.getSource());
            Node currentNode = uiForm.getCurrentNode();
            UIPermissionManager uiParent = (UIPermissionManager)uiForm.getParent();
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            String userOrGroup = (String)((UIPermissionInputSet)uiForm.getChild(UIPermissionInputSet.class)).getUIStringInput("userOrGroup").getValue();
            ArrayList<String> permsList = new ArrayList<String>();
            ArrayList<String> permsRemoveList = new ArrayList<String>();
            if (currentNode.isLocked() && (lockToken = LockUtil.getLockToken((Node)currentNode)) != null) {
                currentNode.getSession().addLockToken(lockToken);
            }
            if (!currentNode.isCheckedOut()) {
                uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.node-checkedin", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            for (String perm : PermissionType.ALL) {
                if (uiForm.getUIFormCheckBoxInput(perm).isChecked()) {
                    permsList.add(perm);
                    continue;
                }
                permsRemoveList.add(perm);
            }
            if ((uiForm.getUIFormCheckBoxInput("add_node").isChecked() || uiForm.getUIFormCheckBoxInput("remove").isChecked() || uiForm.getUIFormCheckBoxInput("set_property").isChecked()) && !permsList.contains("read")) {
                permsList.add("read");
            }
            if (Utils.isNameEmpty((String)userOrGroup)) {
                uiApp.addMessage(new ApplicationMessage("UIPermissionForm.msg.userOrGroup-required", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (permsList.size() == 0) {
                uiApp.addMessage(new ApplicationMessage("UIPermissionForm.msg.checkbox-require", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            String[] permsArray = permsList.toArray(new String[permsList.size()]);
            ExtendedNode node = (ExtendedNode)currentNode;
            if (PermissionUtil.canChangePermission((Node)node)) {
                if (node.canAddMixin("exo:privilegeable")) {
                    node.addMixin("exo:privilegeable");
                    node.setPermission(Utils.getNodeOwner((Node)node), PermissionType.ALL);
                }
                for (String perm : permsRemoveList) {
                    try {
                        node.removePermission(userOrGroup, perm);
                    }
                    catch (AccessDeniedException ade) {
                        uiApp.addMessage(new ApplicationMessage("UIPermissionForm.msg.access-denied", null, 1));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                }
                if (PermissionUtil.canChangePermission((Node)node)) {
                    node.setPermission(userOrGroup, permsArray);
                }
            } else {
                uiApp.addMessage(new ApplicationMessage("UIPermissionForm.msg.not-change-permission", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            node.save();
            ((UIPermissionInfo)uiParent.getChild(UIPermissionInfo.class)).updateGrid();
            uiForm.refresh();
            currentNode.getSession().save();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiParent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResetActionListener
    extends EventListener<UIPermissionForm> {
        public void execute(Event<UIPermissionForm> event) throws Exception {
            UIPermissionForm uiForm = (UIPermissionForm)((Object)event.getSource());
            uiForm.lockForm(false);
            uiForm.refresh();
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }
}

