/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.web.servlet;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.web.servlet.OncePerRequestFilter;

public abstract class AdviceFilter
extends OncePerRequestFilter {
    private static final Log log = LogFactory.getLog(AdviceFilter.class);

    protected boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        return true;
    }

    protected void postHandle(ServletRequest request, ServletResponse response) throws Exception {
    }

    public void afterCompletion(ServletRequest request, ServletResponse response, Exception exception) throws Exception {
    }

    protected void executeChain(ServletRequest request, ServletResponse response, FilterChain chain) throws Exception {
        chain.doFilter(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilterInternal(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        Exception exception = null;
        try {
            boolean continueChain = this.preHandle(request, response);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Invked preHandle method.  Continuing chain?: [" + continueChain + "]"));
            }
            if (continueChain) {
                this.executeChain(request, response, chain);
            }
            this.postHandle(request, response);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Successfully invoked postHandle method");
            }
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            this.cleanup(request, response, exception);
        }
    }

    protected void cleanup(ServletRequest request, ServletResponse response, Exception existing) throws ServletException, IOException {
        Exception exception;
        block6: {
            exception = existing;
            try {
                this.afterCompletion(request, response, exception);
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Successfully invoked afterCompletion method.");
                }
            }
            catch (Exception e) {
                if (exception != null) break block6;
                exception = e;
            }
        }
        if (exception != null) {
            if (exception instanceof ServletException) {
                throw (ServletException)((Object)exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            String msg = "Filter execution resulted in an unexpected Exception (not IOException or ServletException as the Filter api recommends).  Wrapping in ServletException and propagating.";
            throw new ServletException(msg, (Throwable)exception);
        }
    }
}

