/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DeleteFileAction
extends SystemInstallOrUninstallAction {
    private File file;
    private boolean recurse = false;
    private List deletedDirs = new ArrayList();

    public File getFile() {
        return DeleteFileAction.replaceVariables(this.file);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean isRecurse() {
        return this.recurse;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }

    protected boolean execute(Context context) throws UserCanceledException {
        if (this.getFile() == null) {
            return false;
        }
        File file = context.getDestinationFile(this.getFile());
        if (!file.exists()) {
            return true;
        }
        try {
            if (file.isDirectory()) {
                if (this.isRecurse()) {
                    this.emptyDirectory(file, context);
                }
                this.deleteDir(file);
            } else {
                this.deleteFile(file, context);
            }
            return !file.exists();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    private boolean followDir(File file) {
        if (Util.isWindows()) {
            return true;
        }
        UnixFileSystem.FileInformation fileInformation = UnixFileSystem.getFileInformation(file);
        if (fileInformation == null) {
            return true;
        }
        return !fileInformation.isLink();
    }

    private void deleteDir(File file) {
        this.deletedDirs.add(file);
        file.delete();
    }

    private void deleteFile(File file, Context context) throws UserCanceledException {
        if (context instanceof InstallerContext) {
            BackupFileForRollbackAction backupFileForRollbackAction = new BackupFileForRollbackAction(file, true);
            backupFileForRollbackAction.install((InstallerContext)context);
            this.addRollbackAction(backupFileForRollbackAction);
        } else {
            file.delete();
        }
    }

    public void emptyDirectory(File file, Context context) throws IOException, UserCanceledException {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                if (this.followDir(file2)) {
                    this.emptyDirectory(file2, context);
                }
                this.deleteDir(file2);
                continue;
            }
            this.deleteFile(file2, context);
        }
    }

    public void rollback(InstallerContext installerContext) {
        for (int i = 0; i < this.deletedDirs.size(); ++i) {
            ((File)this.deletedDirs.get(i)).mkdirs();
        }
        super.rollback(installerContext);
    }
}

