/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application.javascript;

import javax.servlet.ServletContext;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.gatein.wci.WebAppEvent;
import org.gatein.wci.WebAppLifeCycleEvent;
import org.gatein.wci.WebAppListener;
import org.gatein.wci.impl.DefaultServletContainerFactory;
import org.picocontainer.Startable;

public class JavascriptRemoval
implements WebAppListener,
Startable {
    private String portalContainerName;
    private JavascriptConfigService javascriptService;

    public JavascriptRemoval(String _portalContainerName, JavascriptConfigService _javascriptService) {
        this.portalContainerName = _portalContainerName;
        this.javascriptService = _javascriptService;
    }

    public void onEvent(WebAppEvent arg0) {
        WebAppLifeCycleEvent wevent;
        if (arg0 instanceof WebAppLifeCycleEvent && (wevent = (WebAppLifeCycleEvent)arg0).getType() == 0) {
            this.removeJavascript(wevent.getWebApp().getServletContext());
            this.refreshJavascript();
        }
    }

    private void removeJavascript(ServletContext scontext) {
        String webApp = scontext.getContextPath();
        this.javascriptService.remove(scontext);
    }

    private void refreshJavascript() {
        this.javascriptService.refreshMergedJavascript();
    }

    public void start() {
        DefaultServletContainerFactory.getInstance().getServletContainer().addWebAppListener((WebAppListener)this);
    }

    public void stop() {
        DefaultServletContainerFactory.getInstance().getServletContainer().removeWebAppListener((WebAppListener)this);
    }
}

