/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.jbosscache;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.ChangesFilterListsWrapper;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.IndexerCacheLoader;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.JBossCacheIndexChangesFilter;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.loader.SingletonStoreCacheLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexerSingletonStoreCacheLoader
extends SingletonStoreCacheLoader {
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.IndexerSingletonStoreCacheLoader");

    protected void activeStatusChanged(boolean newActiveState) throws SingletonStoreCacheLoader.PushStateException {
        this.setIndexerMode(newActiveState);
        super.activeStatusChanged(newActiveState);
    }

    protected Callable<?> createPushStateTask() {
        return new Callable(){

            public Object call() throws Exception {
                boolean debugEnabled = IndexerSingletonStoreCacheLoader.this.log.isDebugEnabled();
                if (debugEnabled) {
                    IndexerSingletonStoreCacheLoader.this.log.debug((Object)"start pushing in-memory state to cache cacheLoader collection");
                }
                HashSet<String> removedNodes = new HashSet<String>();
                HashSet<String> addedNodes = new HashSet<String>();
                HashSet<String> parentRemovedNodes = new HashSet<String>();
                HashSet<String> parentAddedNodes = new HashSet<String>();
                Set children = IndexerSingletonStoreCacheLoader.this.cache.getRoot().getChildren();
                for (NodeSPI aChildren : children) {
                    Fqn fqn = aChildren.getFqn();
                    Object value = IndexerSingletonStoreCacheLoader.this.cache.get(fqn, (Object)JBossCacheIndexChangesFilter.LISTWRAPPER);
                    if (value == null || !(value instanceof ChangesFilterListsWrapper)) continue;
                    ChangesFilterListsWrapper listsWrapper = (ChangesFilterListsWrapper)value;
                    addedNodes.addAll(listsWrapper.getAddedNodes());
                    removedNodes.addAll(listsWrapper.getRemovedNodes());
                    parentAddedNodes.addAll(listsWrapper.getParentAddedNodes());
                    parentRemovedNodes.addAll(listsWrapper.getParentAddedNodes());
                }
                String id = IdGenerator.generate();
                IndexerSingletonStoreCacheLoader.this.cache.put(id, (Object)JBossCacheIndexChangesFilter.LISTWRAPPER, (Object)new ChangesFilterListsWrapper(addedNodes, removedNodes, parentAddedNodes, parentRemovedNodes));
                if (debugEnabled) {
                    IndexerSingletonStoreCacheLoader.this.log.debug((Object)"in-memory state passed to cache cacheLoader successfully");
                }
                return null;
            }
        };
    }

    protected void setIndexerMode(boolean writeEnabled) {
        if (this.getCacheLoader() instanceof IndexerCacheLoader) {
            ((IndexerCacheLoader)this.getCacheLoader()).setMode(writeEnabled ? IndexerIoMode.READ_WRITE : IndexerIoMode.READ_ONLY);
            this.log.info((Object)("Set indexer io mode to:" + (Object)((Object)(writeEnabled ? IndexerIoMode.READ_WRITE : IndexerIoMode.READ_ONLY))));
        }
    }
}

