/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import javax.jcr.RepositoryException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ToStringUtils;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexFormatVersion;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrTermQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.NamespaceMappings;
import org.exoplatform.services.jcr.impl.core.query.lucene.RangeQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.Util;

public class NameRangeQuery
extends Query {
    private final InternalQName lowerName;
    private final InternalQName upperName;
    private final boolean inclusive;
    private final IndexFormatVersion version;
    private final NamespaceMappings nsMappings;

    public NameRangeQuery(InternalQName lowerName, InternalQName upperName, boolean inclusive, IndexFormatVersion version, NamespaceMappings nsMappings) {
        if (lowerName == null && upperName == null) {
            throw new IllegalArgumentException("At least one term must be non-null");
        }
        if (lowerName != null && upperName != null && !lowerName.getNamespace().equals(upperName.getNamespace())) {
            throw new IllegalArgumentException("Both names must have the same namespace URI");
        }
        this.lowerName = lowerName;
        this.upperName = upperName;
        this.inclusive = inclusive;
        this.version = version;
        this.nsMappings = nsMappings;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.version.getVersion() >= IndexFormatVersion.V3.getVersion()) {
            RangeQuery localNames = new RangeQuery(this.getLowerLocalNameTerm(), this.getUpperLocalNameTerm(), this.inclusive);
            BooleanQuery query = new BooleanQuery();
            query.add((Query)new JcrTermQuery(new Term(FieldNames.NAMESPACE_URI, this.getNamespaceURI())), BooleanClause.Occur.MUST);
            query.add((Query)localNames, BooleanClause.Occur.MUST);
            return query.rewrite(reader);
        }
        return new RangeQuery(this.getLowerTerm(), this.getUpperTerm(), this.inclusive).rewrite(reader);
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("name():");
        buffer.append(this.inclusive ? "[" : "{");
        buffer.append(this.lowerName != null ? this.lowerName.toString() : "null");
        buffer.append(" TO ");
        buffer.append(this.upperName != null ? this.upperName.toString() : "null");
        buffer.append(this.inclusive ? "]" : "}");
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    private String getNamespaceURI() {
        return this.lowerName != null ? this.lowerName.getNamespace() : this.upperName.getNamespace();
    }

    private Term getLowerLocalNameTerm() {
        if (this.lowerName == null) {
            return null;
        }
        return new Term(FieldNames.LOCAL_NAME, this.lowerName.getName());
    }

    private Term getUpperLocalNameTerm() {
        if (this.upperName == null) {
            return null;
        }
        return new Term(FieldNames.LOCAL_NAME, this.upperName.getName());
    }

    private Term getLowerTerm() throws IOException {
        try {
            String text = this.lowerName == null ? this.nsMappings.getNamespacePrefixByURI(this.upperName.getNamespace()) + ":" : this.nsMappings.translateName(this.lowerName);
            return new Term(FieldNames.LABEL, text);
        }
        catch (RepositoryException e) {
            throw Util.createIOException(e);
        }
        catch (IllegalNameException e) {
            throw Util.createIOException(e);
        }
    }

    private Term getUpperTerm() throws IOException {
        try {
            String text = this.upperName == null ? this.nsMappings.getNamespacePrefixByURI(this.lowerName.getNamespace()) + ":\uffff" : this.nsMappings.translateName(this.upperName);
            return new Term(FieldNames.LABEL, text);
        }
        catch (RepositoryException e) {
            throw Util.createIOException(e);
        }
        catch (IllegalNameException e) {
            throw Util.createIOException(e);
        }
    }
}

