/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util.jdbc.cleaner;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.jcr.RepositoryException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.jcr.impl.storage.jdbc.DialectDetecter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JDBCConfiguration {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JDBCConfiguration");
    public static final String SOURCE_NAME = "source-name";
    public static final String MULTIDB = "multi-db";
    public static final String SINGLEDB = "single-db";
    public static final String DB_DIALECT = "dialect";
    public static final String DB_DRIVER = "driverClassName";
    public static final String DB_URL = "url";
    public static final String DB_USERNAME = "username";
    public static final String DB_PASSWORD = "password";
    public static final String DB_FORCE_QUERY_HINTS = "force.query.hints";
    protected final String containerName;
    protected final String dbSourceName;
    protected final boolean multiDb;
    protected final String dbDriver;
    protected final String dbDialect;
    protected final String dbUrl;
    protected final String dbUserName;
    protected final String dbPassword;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JDBCConfiguration(WorkspaceEntry wsConfig) throws RepositoryConfigurationException, NamingException, RepositoryException, IOException {
        block22: {
            String pDbDialect;
            block25: {
                String sn;
                block23: {
                    block24: {
                        this.containerName = wsConfig.getName();
                        this.multiDb = Boolean.parseBoolean(wsConfig.getContainer().getParameterValue(MULTIDB));
                        pDbDialect = null;
                        try {
                            pDbDialect = this.validateDialect(wsConfig.getContainer().getParameterValue(DB_DIALECT));
                        }
                        catch (RepositoryConfigurationException e) {
                            pDbDialect = DBConstants.DB_DIALECT_GENERIC;
                        }
                        String pDbDriver = null;
                        String pDbUrl = null;
                        String pDbUserName = null;
                        String pDbPassword = null;
                        try {
                            pDbDriver = wsConfig.getContainer().getParameterValue(DB_DRIVER);
                            try {
                                pDbUserName = wsConfig.getContainer().getParameterValue(DB_USERNAME);
                                pDbPassword = wsConfig.getContainer().getParameterValue(DB_PASSWORD);
                            }
                            catch (RepositoryConfigurationException e) {
                                pDbPassword = null;
                                pDbUserName = null;
                            }
                            pDbUrl = wsConfig.getContainer().getParameterValue(DB_URL);
                        }
                        catch (RepositoryConfigurationException e) {
                            // empty catch block
                        }
                        if (pDbUrl == null) break block23;
                        this.dbDriver = pDbDriver;
                        this.dbUrl = pDbUrl;
                        this.dbUserName = pDbUserName;
                        this.dbPassword = pDbPassword;
                        this.dbSourceName = null;
                        LOG.info((Object)("Connect to JCR database as user '" + this.dbUserName + "'"));
                        if (pDbDialect != DBConstants.DB_DIALECT_GENERIC && !DBConstants.DB_DIALECT_AUTO.equalsIgnoreCase(pDbDialect)) break block24;
                        Connection jdbcConn = null;
                        try {
                            try {
                                jdbcConn = this.dbUserName != null ? DriverManager.getConnection(this.dbUrl, this.dbUserName, this.dbPassword) : DriverManager.getConnection(this.dbUrl);
                                this.dbDialect = DialectDetecter.detect(jdbcConn.getMetaData());
                            }
                            catch (SQLException e) {
                                throw new RepositoryException((Throwable)e);
                            }
                            Object var10_11 = null;
                            if (jdbcConn == null) break block22;
                        }
                        catch (Throwable throwable) {
                            Object var10_12 = null;
                            if (jdbcConn == null) throw throwable;
                            try {
                                jdbcConn.close();
                                throw throwable;
                            }
                            catch (SQLException e) {
                                throw new RepositoryException((Throwable)e);
                            }
                        }
                        try {}
                        catch (SQLException e) {
                            throw new RepositoryException((Throwable)e);
                        }
                        jdbcConn.close();
                        break block22;
                    }
                    this.dbDialect = pDbDialect;
                    break block22;
                }
                this.dbDriver = null;
                this.dbUrl = null;
                this.dbUserName = null;
                this.dbPassword = null;
                try {
                    sn = wsConfig.getContainer().getParameterValue(SOURCE_NAME);
                }
                catch (RepositoryConfigurationException e) {
                    sn = wsConfig.getContainer().getParameterValue("sourceName");
                }
                this.dbSourceName = sn;
                if (pDbDialect != DBConstants.DB_DIALECT_GENERIC) break block25;
                DataSource ds = (DataSource)new InitialContext().lookup(this.dbSourceName);
                if (ds == null) throw new RepositoryException("Datasource '" + this.dbSourceName + "' is not bound in this context.");
                Connection jdbcConn = null;
                try {
                    try {
                        jdbcConn = ds.getConnection();
                        this.dbDialect = DialectDetecter.detect(jdbcConn.getMetaData());
                    }
                    catch (SQLException e) {
                        throw new RepositoryException((Throwable)e);
                    }
                    Object var13_21 = null;
                    if (jdbcConn == null) break block22;
                }
                catch (Throwable throwable) {
                    Object var13_22 = null;
                    if (jdbcConn == null) throw throwable;
                    try {
                        jdbcConn.close();
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RepositoryException((Throwable)e);
                    }
                }
                try {}
                catch (SQLException e) {
                    throw new RepositoryException((Throwable)e);
                }
                jdbcConn.close();
                break block22;
            }
            this.dbDialect = pDbDialect;
        }
        LOG.info((Object)("Using a dialect '" + this.dbDialect + "'"));
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getDbSourceName() {
        return this.dbSourceName;
    }

    public boolean isMultiDb() {
        return this.multiDb;
    }

    public String getDbDriver() {
        return this.dbDriver;
    }

    public String getDbDialect() {
        return this.dbDialect;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public String getDbUserName() {
        return this.dbUserName;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    protected String validateDialect(String confParam) {
        for (String dbType : DBConstants.DB_DIALECTS) {
            if (!dbType.equalsIgnoreCase(confParam)) continue;
            return dbType;
        }
        return DBConstants.DB_DIALECT_GENERIC;
    }
}

