/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util.jdbc.cleaner;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializer;
import org.exoplatform.services.jcr.impl.util.jdbc.cleaner.DBCleaner;
import org.exoplatform.services.jcr.impl.util.jdbc.cleaner.DBCleanerException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkspaceDBCleaner
implements DBCleaner {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.WorkspaceDBCleaner");
    protected final String containerName;
    protected final Connection connection;
    protected final Pattern dbObjectNamePattern;
    protected final List<String> commonDBCleanScripts = new ArrayList<String>();

    public WorkspaceDBCleaner(WorkspaceEntry wsEntry, Connection connection) {
        this.dbObjectNamePattern = Pattern.compile(DBInitializer.SQL_OBJECTNAME, 2);
        this.connection = connection;
        this.containerName = wsEntry.getName();
    }

    /*
     * Loose catch block
     */
    @Override
    public void clean() throws DBCleanerException {
        block12: {
            String sql = null;
            Statement st = null;
            this.connection.setAutoCommit(false);
            st = this.connection.createStatement();
            for (String scr : this.getDBCleanScripts()) {
                String s = this.cleanWhitespaces(scr.trim());
                if (s.length() <= 0 || !this.canExecuteQuery(sql = s)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Execute script: \n[" + sql + "]"));
                }
                this.executeQuery(st, sql);
            }
            this.connection.commit();
            Object var7_8 = null;
            if (st == null) break block12;
            try {
                st.close();
                break block12;
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the Statement: " + e));
            }
            {
                break block12;
                catch (SQLException e) {
                    try {
                        this.connection.rollback();
                    }
                    catch (SQLException rollbackException) {
                        LOG.error((Object)("Can not rollback changes after exception " + e.getMessage()), (Throwable)rollbackException);
                    }
                    throw new DBCleanerException(e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e) {
                        LOG.error((Object)("Can't close the Statement: " + e));
                    }
                }
                this.closeConnection();
                throw throwable;
            }
        }
        this.closeConnection();
    }

    protected void closeConnection() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            LOG.error((Object)("Error of a connection closing. " + e), (Throwable)e);
        }
    }

    protected boolean canExecuteQuery(String sql) throws SQLException {
        Matcher tMatcher = this.dbObjectNamePattern.matcher(sql);
        while (tMatcher.find()) {
            String tableName = sql.substring(tMatcher.start(), tMatcher.end());
            if (this.isTableExists(this.connection, tableName)) continue;
            LOG.warn((Object)("Table [" + tableName + "] from query [" + sql + "] was not found. So query will not be executed."));
            return false;
        }
        return true;
    }

    protected void executeQuery(Statement statement, String sql) throws SQLException {
        statement.executeUpdate(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isTableExists(Connection conn, String tableName) throws SQLException {
        boolean bl;
        ResultSet trs = conn.getMetaData().getTables(null, null, tableName, null);
        try {
            boolean res = false;
            while (trs.next()) {
                res = true;
            }
            bl = res;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                trs.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
            throw throwable;
        }
        try {
            trs.close();
        }
        catch (SQLException e) {
            LOG.error((Object)("Can't close the ResultSet: " + e));
        }
        return bl;
    }

    private String cleanWhitespaces(String string) {
        if (string != null) {
            char[] cc = string.toCharArray();
            for (int ci = cc.length - 1; ci > 0; --ci) {
                if (!Character.isWhitespace(cc[ci])) continue;
                cc[ci] = 32;
            }
            return new String(cc);
        }
        return string;
    }

    abstract List<String> getDBCleanScripts();
}

