/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.application;

import java.util.HashMap;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.relationship.RelationshipEvent;
import org.exoplatform.social.core.relationship.RelationshipListenerPlugin;
import org.exoplatform.social.core.relationship.model.Relationship;

public class RelationshipPublisher
extends RelationshipListenerPlugin {
    public static final String SENDER_PARAM = "SENDER";
    public static final String RECEIVER_PARAM = "RECEIVER";
    public static final String RELATIONSHIP_ACTIVITY_TYPE = "exosocial:relationship";
    private static final Log LOG = ExoLogger.getLogger(RelationshipPublisher.class);
    private ActivityManager activityManager;
    private IdentityManager identityManager;

    public RelationshipPublisher(InitParams params, ActivityManager activityManager, IdentityManager identityManager) {
        this.activityManager = activityManager;
        this.identityManager = identityManager;
    }

    public void confirmed(RelationshipEvent event) {
        Relationship relationship = (Relationship)event.getPayload();
        try {
            Identity id1 = relationship.getSender();
            this.reloadIfNeeded(id1);
            Identity id2 = relationship.getReceiver();
            this.reloadIfNeeded(id2);
            String user1 = id1.getRemoteId();
            String user2 = id2.getRemoteId();
            Activity activity = new Activity(id1.getId(), RELATIONSHIP_ACTIVITY_TYPE, "I am now connected with @" + user2, null);
            activity.setTitleId(TitleId.CONNECTION_CONFIRMED.toString());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(SENDER_PARAM, user1);
            params.put(RECEIVER_PARAM, user2);
            activity.setTemplateParams(params);
            this.activityManager.saveActivity(id1, activity);
            Activity activity2 = new Activity(id2.getId(), RELATIONSHIP_ACTIVITY_TYPE, "I am now connected with @" + user1, null);
            activity2.setTitleId(TitleId.CONNECTION_CONFIRMED.toString());
            HashMap<String, String> params2 = new HashMap<String, String>();
            params2.put(SENDER_PARAM, user2);
            params2.put(RECEIVER_PARAM, user1);
            activity2.setTemplateParams(params2);
            this.activityManager.saveActivity(id2, activity2);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to publish event " + (Object)((Object)event) + ": " + e.getMessage()));
        }
    }

    private void reloadIfNeeded(Identity identity) throws Exception {
        if (identity.getId() == null || identity.getProfile().getFullName().length() == 0) {
            identity = this.identityManager.getIdentity(identity.getGlobalId().toString(), true);
        }
    }

    public void ignored(RelationshipEvent event) {
    }

    public void removed(RelationshipEvent event) {
    }

    public void denied(RelationshipEvent event) {
    }

    public void requested(RelationshipEvent event) {
        Relationship relationship = (Relationship)event.getPayload();
        try {
            Identity id1 = relationship.getSender();
            this.reloadIfNeeded(id1);
            Identity id2 = relationship.getReceiver();
            this.reloadIfNeeded(id2);
            String user1 = id1.getRemoteId();
            String user2 = id2.getRemoteId();
            Activity activity2 = new Activity(id2.getId(), RELATIONSHIP_ACTIVITY_TYPE, "@" + user1 + " has invited @" + user2 + " to connect", null);
            activity2.setTitleId(TitleId.CONNECTION_REQUESTED.toString());
            HashMap<String, String> params2 = new HashMap<String, String>();
            params2.put(SENDER_PARAM, user1);
            params2.put(RECEIVER_PARAM, user2);
            activity2.setTemplateParams(params2);
            this.activityManager.saveActivity(id2, activity2);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to publish event " + (Object)((Object)event) + ": " + e.getMessage()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TitleId {
        CONNECTION_REQUESTED,
        CONNECTION_CONFIRMED;

    }
}

