/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.fieldtypes;

import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldType;
import org.apache.sanselan.util.Debug;

public class FieldTypeFloat
extends FieldType {
    public FieldTypeFloat() {
        super(11, 4, "Float");
    }

    public Object getSimpleValue(TiffField entry) {
        if (entry.length == 1) {
            return new Float(this.convertByteArrayToFloat(this.name + " (" + entry.tagInfo.name + ")", entry.valueOffsetBytes, entry.byteOrder));
        }
        return this.convertByteArrayToFloatArray(this.name + " (" + entry.tagInfo.name + ")", this.getRawBytes(entry), 0, entry.length, entry.byteOrder);
    }

    public byte[] writeData(Object o, int byteOrder) throws ImageWriteException {
        if (o instanceof Float) {
            return this.convertFloatToByteArray(((Float)o).floatValue(), byteOrder);
        }
        if (o instanceof float[]) {
            float[] numbers = (float[])o;
            return this.convertFloatArrayToByteArray(numbers, byteOrder);
        }
        if (o instanceof Float[]) {
            Float[] numbers = (Float[])o;
            float[] values = new float[numbers.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = numbers[i].floatValue();
            }
            return this.convertFloatArrayToByteArray(values, byteOrder);
        }
        throw new ImageWriteException("Invalid data: " + o + " (" + Debug.getType(o) + ")");
    }
}

