/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.concurrent;

import java.io.Serializable;
import org.exoplatform.services.cache.CacheInfo;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CacheListenerContext;
import org.exoplatform.services.cache.concurrent.ConcurrentFIFOExoCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerContext<K, V>
implements CacheListenerContext,
CacheInfo {
    private final ConcurrentFIFOExoCache cache;
    final CacheListener<? super K, ? super V> listener;

    public ListenerContext(CacheListener<? super K, ? super V> listener, ConcurrentFIFOExoCache cache) {
        this.listener = listener;
        this.cache = cache;
    }

    @Override
    public CacheInfo getCacheInfo() {
        return this;
    }

    @Override
    public String getName() {
        return this.cache.getName();
    }

    @Override
    public int getMaxSize() {
        return this.cache.getMaxSize();
    }

    @Override
    public long getLiveTime() {
        return this.cache.getLiveTime();
    }

    @Override
    public int getSize() {
        return this.cache.getCacheSize();
    }

    void onExpire(K key, V obj) {
        try {
            this.listener.onExpire(this, (Serializable)key, obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void onRemove(K key, V obj) {
        try {
            this.listener.onRemove(this, (Serializable)key, obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void onPut(K key, V obj) {
        try {
            this.listener.onPut(this, (Serializable)key, obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void onGet(K key, V obj) {
        try {
            this.listener.onGet(this, (Serializable)key, obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void onClearCache() {
        try {
            this.listener.onClearCache(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

