/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.http;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHeader
implements Serializable {
    private String name;
    private List<Element> elements = new ArrayList<Element>();

    public HttpHeader(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Element addElement(String name) {
        return this.addElement(new Element(name));
    }

    public Element addElement(String name, String value) {
        return this.addElement(new Element(name, value));
    }

    public Element addElement(Element element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        this.elements.add(element);
        return element;
    }

    public Element getElement() {
        if (this.elements.size() > 0) {
            return this.elements.get(0);
        }
        return null;
    }

    public Iterator<Element> elements() {
        return this.elements.iterator();
    }

    public String getValue() {
        StringBuffer buffer = new StringBuffer();
        Iterator<Element> j = this.elements();
        while (j.hasNext()) {
            Element elt = j.next();
            buffer.append(elt.getName());
            if (elt.getValue() != null) {
                buffer.append("=").append(elt.getValue());
            }
            Iterator<Element.Param> k = elt.params();
            while (k.hasNext()) {
                Element.Param param = k.next();
                buffer.append(";").append(param.getName());
                if (param.getValue() == null) continue;
                buffer.append("=").append(param.getValue());
            }
            if (!j.hasNext()) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    public String toString() {
        return this.name + ": " + this.getValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Element
    implements Serializable {
        private String name;
        private String value;
        private List<Param> params;

        public Element(String name) {
            this(name, null);
        }

        public Element(String name, String value) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            this.name = name;
            this.value = value;
            this.params = new ArrayList<Param>();
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public Param addParam(String name) {
            return this.addParam(new Param(name));
        }

        public Param addParam(String name, String value) {
            return this.addParam(new Param(name, value));
        }

        public Param addParam(Param param) {
            if (param == null) {
                throw new IllegalArgumentException();
            }
            this.params.add(param);
            return param;
        }

        public Param getParam() {
            if (this.params.size() > 0) {
                return this.params.get(0);
            }
            return null;
        }

        public Iterator<Param> params() {
            return this.params.iterator();
        }

        public static class Param
        implements Serializable {
            private String name;
            private String value;

            public Param(String name) {
                this(name, null);
            }

            public Param(String name, String value) {
                if (name == null) {
                    throw new IllegalArgumentException();
                }
                this.name = name;
                this.value = value;
            }

            public String getName() {
                return this.name;
            }

            public String getValue() {
                return this.value;
            }
        }
    }
}

