/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.net.media;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gatein.common.net.media.MediaType;
import org.gatein.common.net.media.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentType {
    private MediaType mediaType;
    private List<Parameter> parameters;

    public static ContentType create(String contentTypeValue) throws IllegalArgumentException {
        if (contentTypeValue == null) {
            throw new IllegalArgumentException("No null content type value accepted");
        }
        int slashIndex = contentTypeValue.indexOf(47);
        if (slashIndex == -1) {
            throw new IllegalArgumentException("The content type " + contentTypeValue + " does not contain a /");
        }
        String typeName = contentTypeValue.substring(0, slashIndex);
        int semiColonIndex = contentTypeValue.indexOf(59, slashIndex + 1);
        if (semiColonIndex == -1) {
            return new ContentType(MediaType.create(typeName, contentTypeValue.substring(slashIndex + 1)));
        }
        String subtypeName = contentTypeValue.substring(slashIndex + 1, semiColonIndex);
        MediaType mediaType = MediaType.create(typeName, subtypeName);
        List<Parameter> parameters = null;
        int i = semiColonIndex + 1;
        while (semiColonIndex != -1) {
            semiColonIndex = contentTypeValue.indexOf(59, i);
            if (semiColonIndex == 0) {
                throw new IllegalArgumentException();
            }
            int to = semiColonIndex == -1 ? contentTypeValue.length() : semiColonIndex;
            int equalsIndex = contentTypeValue.indexOf(61, i);
            if (equalsIndex != -1 && equalsIndex < to) {
                if (parameters == null) {
                    parameters = new ArrayList<Parameter>();
                }
            } else {
                throw new IllegalArgumentException("No equals char found in the string " + contentTypeValue.substring(i, to));
            }
            String name = contentTypeValue.substring(i, equalsIndex);
            String value = contentTypeValue.substring(equalsIndex + 1, to);
            parameters.add(new Parameter(name, value));
            i = semiColonIndex + 1;
        }
        if (parameters == null) {
            parameters = Collections.emptyList();
        }
        return new ContentType(mediaType, parameters);
    }

    public ContentType(MediaType mediaType, List<Parameter> parameters) {
        if (mediaType == null) {
            throw new IllegalArgumentException("No null media type accepted");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("No null parameter list accepted");
        }
        this.mediaType = mediaType;
        this.parameters = parameters;
    }

    public ContentType(MediaType mediaType) {
        if (mediaType == null) {
            throw new IllegalArgumentException("No null media type accepted");
        }
        this.mediaType = mediaType;
        this.parameters = Collections.emptyList();
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public String getValue() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.mediaType.getValue());
        for (Parameter parameter : this.parameters) {
            builder.append(';').append(parameter.getName()).append('=').append(parameter.getValue());
        }
        return builder.toString();
    }
}

