/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.io.IOException;
import java.io.NotSerializableException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.commands.read.GetChildrenNamesCommand;
import org.jboss.cache.commands.read.GetDataMapCommand;
import org.jboss.cache.commands.read.GetKeyValueCommand;
import org.jboss.cache.commands.read.GetKeysCommand;
import org.jboss.cache.commands.read.GetNodeCommand;
import org.jboss.cache.commands.write.ClearDataCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveKeyCommand;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.marshall.MarshalledValue;
import org.jboss.cache.marshall.MarshalledValueHelper;
import org.jboss.cache.marshall.MarshalledValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshalledValueInterceptor
extends CommandInterceptor {
    @Override
    public Object visitPutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
        if (command.getDataVersion() != null) {
            return this.invokeNextInterceptor(ctx, command);
        }
        HashSet<MarshalledValue> marshalledValues = new HashSet<MarshalledValue>();
        command.setData(this.wrapMap(command.getData(), marshalledValues, ctx));
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return ctx.isBypassUnmarshalling() ? retVal : this.compactAndProcessRetVal(marshalledValues, retVal);
    }

    @Override
    public Object visitGetDataMapCommand(InvocationContext ctx, GetDataMapCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        if (retVal instanceof Map) {
            if (this.trace) {
                this.log.trace((Object)"Return value is a Map and we're retrieving data.  Wrapping as a MarshalledValueMap.");
            }
            Map retValMap = (Map)retVal;
            if (!ctx.isBypassUnmarshalling() && !retValMap.isEmpty()) {
                retVal = new MarshalledValueMap(retValMap);
            }
        }
        return retVal;
    }

    @Override
    public Object visitPutForExternalReadCommand(InvocationContext ctx, PutForExternalReadCommand command) throws Throwable {
        return this.visitPutKeyValueCommand(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        HashSet<MarshalledValue> marshalledValues = new HashSet<MarshalledValue>();
        if (!MarshalledValueHelper.isTypeExcluded(command.getKey().getClass())) {
            MarshalledValue newKey = this.createAndAddMarshalledValue(command.getKey(), marshalledValues, ctx);
            command.setKey(newKey);
        }
        if (!MarshalledValueHelper.isTypeExcluded(command.getValue().getClass())) {
            MarshalledValue value = this.createAndAddMarshalledValue(command.getValue(), marshalledValues, ctx);
            command.setValue(value);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return ctx.isBypassUnmarshalling() ? retVal : this.compactAndProcessRetVal(marshalledValues, retVal);
    }

    @Override
    public Object visitGetNodeCommand(InvocationContext ctx, GetNodeCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return ctx.isBypassUnmarshalling() ? retVal : this.processRetVal(retVal);
    }

    @Override
    public Object visitClearDataCommand(InvocationContext ctx, ClearDataCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return ctx.isBypassUnmarshalling() ? retVal : this.processRetVal(retVal);
    }

    @Override
    public Object visitRemoveKeyCommand(InvocationContext ctx, RemoveKeyCommand command) throws Throwable {
        HashSet<MarshalledValue> marshalledValues = new HashSet<MarshalledValue>();
        if (!MarshalledValueHelper.isTypeExcluded(command.getKey().getClass())) {
            MarshalledValue value = this.createAndAddMarshalledValue(command.getKey(), marshalledValues, ctx);
            command.setKey(value);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return ctx.isBypassUnmarshalling() ? retVal : this.compactAndProcessRetVal(marshalledValues, retVal);
    }

    @Override
    public Object visitGetChildrenNamesCommand(InvocationContext ctx, GetChildrenNamesCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return ctx.isBypassUnmarshalling() ? retVal : this.processRetVal(retVal);
    }

    @Override
    public Object visitGetKeysCommand(InvocationContext ctx, GetKeysCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return ctx.isBypassUnmarshalling() ? retVal : this.processRetVal(retVal);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        HashSet<MarshalledValue> marshalledValues = new HashSet<MarshalledValue>();
        if (!MarshalledValueHelper.isTypeExcluded(command.getKey().getClass())) {
            MarshalledValue value = this.createAndAddMarshalledValue(command.getKey(), marshalledValues, ctx);
            command.setKey(value);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return ctx.isBypassUnmarshalling() ? retVal : this.compactAndProcessRetVal(marshalledValues, retVal);
    }

    private Object compactAndProcessRetVal(Set<MarshalledValue> marshalledValues, Object retVal) throws IOException, ClassNotFoundException {
        if (this.trace) {
            this.log.trace((Object)"Compacting MarshalledValues created");
        }
        for (MarshalledValue mv : marshalledValues) {
            mv.compact(false, false);
        }
        return this.processRetVal(retVal);
    }

    private Object processRetVal(Object retVal) throws IOException, ClassNotFoundException {
        if (retVal instanceof MarshalledValue) {
            if (this.trace) {
                this.log.trace((Object)"Return value is a MarshalledValue.  Unwrapping.");
            }
            retVal = ((MarshalledValue)retVal).get();
        }
        return retVal;
    }

    protected Map wrapMap(Map<Object, Object> m, Set<MarshalledValue> marshalledValues, InvocationContext ctx) throws NotSerializableException {
        if (m == null) {
            if (this.trace) {
                this.log.trace((Object)"Map is nul; returning an empty map.");
            }
            return Collections.emptyMap();
        }
        if (this.trace) {
            this.log.trace((Object)("Wrapping map contents of argument " + m));
        }
        HashMap<Object, Object> copy = new HashMap<Object, Object>();
        for (Map.Entry<Object, Object> me : m.entrySet()) {
            Object key = me.getKey();
            Object value = me.getValue();
            copy.put(key == null || MarshalledValueHelper.isTypeExcluded(key.getClass()) ? key : this.createAndAddMarshalledValue(key, marshalledValues, ctx), value == null || MarshalledValueHelper.isTypeExcluded(value.getClass()) ? value : this.createAndAddMarshalledValue(value, marshalledValues, ctx));
        }
        return copy;
    }

    protected MarshalledValue createAndAddMarshalledValue(Object toWrap, Set<MarshalledValue> marshalledValues, InvocationContext ctx) throws NotSerializableException {
        MarshalledValue mv = new MarshalledValue(toWrap);
        marshalledValues.add(mv);
        if (!ctx.isOriginLocal()) {
            mv.setEqualityPreferenceForInstance(false);
        }
        return mv;
    }
}

