/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.wadl;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.exoplatform.services.rest.impl.resource.AbstractResourceDescriptorImpl;
import org.exoplatform.services.rest.method.MethodParameter;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;
import org.exoplatform.services.rest.resource.ResourceMethodDescriptor;
import org.exoplatform.services.rest.resource.ResourceMethodMap;
import org.exoplatform.services.rest.resource.SubResourceLocatorDescriptor;
import org.exoplatform.services.rest.resource.SubResourceMethodDescriptor;
import org.exoplatform.services.rest.resource.SubResourceMethodMap;
import org.exoplatform.services.rest.wadl.BaseWadlGeneratorImpl;
import org.exoplatform.services.rest.wadl.WadlGenerator;
import org.exoplatform.services.rest.wadl.research.Application;
import org.exoplatform.services.rest.wadl.research.Method;
import org.exoplatform.services.rest.wadl.research.Param;
import org.exoplatform.services.rest.wadl.research.ParamStyle;
import org.exoplatform.services.rest.wadl.research.RepresentationType;
import org.exoplatform.services.rest.wadl.research.Request;
import org.exoplatform.services.rest.wadl.research.Resource;
import org.exoplatform.services.rest.wadl.research.Resources;
import org.exoplatform.services.rest.wadl.research.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WadlProcessor {
    private final WadlGenerator wadlGenerator;

    public WadlProcessor() {
        this.wadlGenerator = new BaseWadlGeneratorImpl();
    }

    public WadlProcessor(WadlGenerator wadlGenerator) {
        this.wadlGenerator = wadlGenerator;
    }

    public Application process(AbstractResourceDescriptor resourceDescriptor, URI baseURI) {
        Application wadlApp = this.wadlGenerator.createApplication();
        Resources wadlResources = this.wadlGenerator.createResources();
        if (baseURI != null) {
            wadlResources.setBase(baseURI.toString());
        }
        Resource wadlResource = this.processResource(resourceDescriptor);
        wadlResources.getResource().add(wadlResource);
        wadlApp.setResources(wadlResources);
        return wadlApp;
    }

    private Resource processResource(AbstractResourceDescriptor resourceDescriptor) {
        Resource wadlResource = this.wadlGenerator.createResource(resourceDescriptor);
        HashMap<String, Param> wadlResourceParams = new HashMap<String, Param>();
        ResourceMethodMap<ResourceMethodDescriptor> resourceMethods = resourceDescriptor.getResourceMethods();
        for (List l : resourceMethods.values()) {
            for (ResourceMethodDescriptor rmd : l) {
                Method wadlMethod = this.processMethod(rmd, wadlResourceParams);
                if (wadlMethod == null) continue;
                wadlResource.getMethodOrResource().add(wadlMethod);
            }
        }
        for (Param p : wadlResourceParams.values()) {
            wadlResource.getParam().add(p);
        }
        this.processSubResourceMethods(wadlResource, resourceDescriptor);
        this.processSubResourceLocators(wadlResource, resourceDescriptor);
        return wadlResource;
    }

    private void processSubResourceMethods(Resource wadlResource, AbstractResourceDescriptor resourceDescriptor) {
        HashMap<String, HashMap<String, Param>> wadlCommonSubResourceParams = new HashMap<String, HashMap<String, Param>>();
        HashMap<String, Resource> wadlSubResources = new HashMap<String, Resource>();
        SubResourceMethodMap subresourceMethods = resourceDescriptor.getSubResourceMethods();
        for (ResourceMethodMap resourceMethodMap : subresourceMethods.values()) {
            for (List l : resourceMethodMap.values()) {
                for (SubResourceMethodDescriptor srmd : l) {
                    Method wadlMethod;
                    HashMap<String, Param> wadlResourceParams;
                    String path = srmd.getPathValue().getPath();
                    Resource wadlSubResource = (Resource)wadlSubResources.get(path);
                    if (wadlSubResource == null) {
                        wadlSubResource = this.wadlGenerator.createResource(path);
                        wadlResourceParams = new HashMap<String, Param>();
                        wadlMethod = this.processMethod(srmd, wadlResourceParams);
                        if (wadlMethod == null) continue;
                        wadlSubResource.getMethodOrResource().add(wadlMethod);
                        wadlSubResources.put(path, wadlSubResource);
                        wadlCommonSubResourceParams.put(path, wadlResourceParams);
                        continue;
                    }
                    wadlResourceParams = (HashMap<String, Param>)wadlCommonSubResourceParams.get(path);
                    wadlMethod = this.processMethod(srmd, wadlResourceParams);
                    if (wadlMethod == null) continue;
                    wadlSubResource.getMethodOrResource().add(wadlMethod);
                }
            }
        }
        for (Map.Entry entry : wadlSubResources.entrySet()) {
            String path = (String)entry.getKey();
            Resource wadlSubResource = (Resource)entry.getValue();
            for (Param wadlSubParam : ((Map)wadlCommonSubResourceParams.get(path)).values()) {
                wadlSubResource.getParam().add(wadlSubParam);
            }
            wadlResource.getMethodOrResource().add(wadlSubResource);
        }
    }

    private void processSubResourceLocators(Resource wadlResource, AbstractResourceDescriptor resourceDescriptor) {
        for (SubResourceLocatorDescriptor srld : resourceDescriptor.getSubResourceLocators().values()) {
            AbstractResourceDescriptorImpl subResourceDescriptor = new AbstractResourceDescriptorImpl(srld.getMethod().getReturnType());
            Resource wadlSubResource = this.processResource(subResourceDescriptor);
            wadlSubResource.setPath(srld.getPathValue().getPath());
            wadlResource.getMethodOrResource().add(wadlSubResource);
        }
    }

    private Method processMethod(ResourceMethodDescriptor rmd, Map<String, Param> wadlResourceParams) {
        Response wadlResponse;
        Method wadlMethod = this.wadlGenerator.createMethod(rmd);
        if (wadlMethod == null) {
            return null;
        }
        Request wadlRequest = this.processRequest(rmd, wadlResourceParams);
        if (wadlRequest != null) {
            wadlMethod.setRequest(wadlRequest);
        }
        if ((wadlResponse = this.processResponse(rmd)) != null) {
            wadlMethod.setResponse(wadlResponse);
        }
        return wadlMethod;
    }

    private Request processRequest(ResourceMethodDescriptor rmd, Map<String, Param> wadlResourceParams) {
        Request wadlRequest = this.wadlGenerator.createRequest();
        for (MethodParameter methodParameter : rmd.getMethodParameters()) {
            Param wadlParam;
            if (methodParameter.getAnnotation() == null) {
                for (MediaType mediaType : rmd.consumes()) {
                    RepresentationType wadlRepresentation = this.wadlGenerator.createRequestRepresentation(mediaType);
                    wadlRequest.getRepresentation().add(wadlRepresentation);
                }
            }
            if ((wadlParam = this.processParam(methodParameter)) == null) continue;
            if (wadlParam.getStyle() == ParamStyle.QUERY || wadlParam.getStyle() == ParamStyle.HEADER) {
                wadlRequest.getParam().add(wadlParam);
                continue;
            }
            wadlResourceParams.put(wadlParam.getName(), wadlParam);
        }
        return wadlRequest.getRepresentation().isEmpty() && wadlRequest.getParam().isEmpty() ? null : wadlRequest;
    }

    private Response processResponse(ResourceMethodDescriptor rmd) {
        Response wadlResponse = null;
        if (rmd.getResponseType() != Void.TYPE) {
            wadlResponse = this.wadlGenerator.createResponse();
            for (MediaType mediaType : rmd.produces()) {
                RepresentationType wadlRepresentation = this.wadlGenerator.createResponseRepresentation(mediaType);
                JAXBElement wadlRepresentationElement = new JAXBElement(new QName("http://research.sun.com/wadl/2006/10", "representation"), RepresentationType.class, (Object)wadlRepresentation);
                wadlResponse.getRepresentationOrFault().add((JAXBElement<RepresentationType>)wadlRepresentationElement);
            }
        }
        return wadlResponse;
    }

    private Param processParam(MethodParameter methodParameter) {
        Param wadlParam = null;
        if (methodParameter.getAnnotation() != null && methodParameter.getAnnotation().annotationType() != Context.class) {
            wadlParam = this.wadlGenerator.createParam(methodParameter);
        }
        return wadlParam;
    }
}

