/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.lifecycle.simple.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Locale;
import javax.jcr.Node;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.publication.lifecycle.simple.ui.UIPublishingPanel;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/wcm/webui/publication/lifecycle/simple/ui/UIPublicationStatus.gtmpl", events={@EventConfig(listeners={CloseActionListener.class})})
public class UIPublicationComponentStatus
extends UIForm {
    private NodeLocation nodeLocation;

    public UIPublicationComponentStatus() throws Exception {
    }

    public UIPublicationComponentStatus(Node node) throws Exception {
        this.nodeLocation = NodeLocation.make((Node)node);
    }

    public Node getNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.nodeLocation);
    }

    public void setNode(Node node) {
        this.nodeLocation = NodeLocation.make((Node)node);
    }

    public String getNodeName() {
        try {
            return this.getNode().getName();
        }
        catch (Exception e) {
            return "Error in getNodeName";
        }
    }

    public String getLifeCycleName() {
        try {
            PublicationService service = (PublicationService)this.getApplicationComponent(PublicationService.class);
            return service.getNodeLifecycleName(this.getNode());
        }
        catch (Exception e) {
            return "Error in getLifeCycleName";
        }
    }

    public String getStateName() {
        try {
            PublicationService service = (PublicationService)this.getApplicationComponent(PublicationService.class);
            return service.getCurrentState(this.getNode());
        }
        catch (Exception e) {
            return "Error in getStateName";
        }
    }

    public String getLinkStateImage(Locale locale) {
        try {
            DownloadService dS = (DownloadService)this.getApplicationComponent(DownloadService.class);
            PublicationService service = (PublicationService)this.getApplicationComponent(PublicationService.class);
            byte[] bytes = service.getStateImage(this.getNode(), locale);
            ByteArrayInputStream iS = new ByteArrayInputStream(bytes);
            String id = dS.addDownloadResource((DownloadResource)new InputStreamDownloadResource((InputStream)iS, "image/gif"));
            return dS.getDownloadLink(id);
        }
        catch (Exception e) {
            return "Error in getStateImage";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIPublicationComponentStatus> {
        public void execute(Event<UIPublicationComponentStatus> event) throws Exception {
            UIPublicationComponentStatus publicationComponentStatus = (UIPublicationComponentStatus)((Object)event.getSource());
            UIPublishingPanel publishingPanel = (UIPublishingPanel)publicationComponentStatus.getAncestorOfType(UIPublishingPanel.class);
            UIPopupWindow popupAction = (UIPopupWindow)publishingPanel.getAncestorOfType(UIPopupWindow.class);
            popupAction.setShow(false);
            popupAction.setRendered(false);
        }
    }
}

