/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.instantiation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.jbpm.instantiation.FieldInstantiator;
import org.jbpm.instantiation.Instantiator;

public class BeanInstantiator
extends FieldInstantiator
implements Instantiator {
    private static final Log log = LogFactory.getLog((Class)BeanInstantiator.class);

    protected void setPropertyValue(Class clazz, Object newInstance, String propertyName, Element propertyElement) {
        String setterMethodName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        Method method = this.findSetter(clazz, setterMethodName);
        if (method != null) {
            method.setAccessible(true);
            Class<?> propertyType = method.getParameterTypes()[0];
            Object value = BeanInstantiator.getValue(propertyType, propertyElement);
            try {
                method.invoke(newInstance, value);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("property '" + propertyName + "' cannot be set to value: " + value), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)("property '" + propertyName + "' is inaccessible"), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)("property setter '" + setterMethodName + "' threw exception"), e.getCause());
            }
        } else {
            log.error((Object)("property '" + propertyName + "' has no setter method"));
        }
    }

    private Method findSetter(Class clazz, String setterMethodName) {
        do {
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().equals(setterMethodName) || method.getParameterTypes().length != 1) continue;
                return method;
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return null;
    }
}

