/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.namespace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.jcr.NamespaceRegistry;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.namespace.UINamespaceForm;
import org.exoplatform.ecm.webui.component.admin.namespace.UINamespaceManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/ecm/webui/UIGridWithButton.gtmpl", events={@EventConfig(listeners={AddNamespaceActionListener.class})})
public class UINamespaceList
extends UIGrid {
    private static String[] NAMESPACE_BEAN_FIELD = new String[]{"prefix", "uri"};

    public UINamespaceList() throws Exception {
        this.getUIPageIterator().setId("NamespaceListIterator");
        this.configure("prefix", NAMESPACE_BEAN_FIELD, null);
    }

    public String[] getActions() {
        return new String[]{"AddNamespace"};
    }

    public void updateGrid() throws Exception {
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        NamespaceRegistry namespaceRegistry = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repository).getNamespaceRegistry();
        ArrayList<NamespaceBean> nspBeans = new ArrayList<NamespaceBean>();
        String[] prefixs = namespaceRegistry.getPrefixes();
        for (int i = 0; i < prefixs.length - 1; ++i) {
            NamespaceBean bean = new NamespaceBean(prefixs[i], namespaceRegistry.getURI(prefixs[i]));
            nspBeans.add(bean);
        }
        Collections.sort(nspBeans, new NameSpaceComparator());
        ObjectPageList objPageList = new ObjectPageList(nspBeans, 10);
        this.getUIPageIterator().setPageList((PageList)objPageList);
    }

    public static class NamespaceBean {
        private String prefix;
        private String uri;

        public NamespaceBean(String prefix, String uri) {
            this.prefix = prefix;
            this.uri = uri;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getUri() {
            return this.uri;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddNamespaceActionListener
    extends EventListener<UINamespaceList> {
        public void execute(Event<UINamespaceList> event) throws Exception {
            UINamespaceManager uiManager = (UINamespaceManager)((UINamespaceList)((Object)event.getSource())).getParent();
            uiManager.initPopup();
            UINamespaceForm uiForm = (UINamespaceForm)uiManager.findFirstComponentOfType(UINamespaceForm.class);
            uiForm.reset();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    public static class NameSpaceComparator
    implements Comparator {
        public int compare(Object o1, Object o2) throws ClassCastException {
            String name1 = ((NamespaceBean)o1).getPrefix();
            String name2 = ((NamespaceBean)o2).getPrefix();
            return name1.compareToIgnoreCase(name2);
        }
    }
}

