/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.conversationstate;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="/conversation-state")
public class RestConversationState
implements ResourceContainer {
    private final Log log = ExoLogger.getLogger((String)"rest.RestConversationState");

    @GET
    @Path(value="/whoami")
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    public Response whoami() {
        CacheControl cc = new CacheControl();
        cc.setNoCache(true);
        cc.setNoStore(true);
        ConversationState curentState = ConversationState.getCurrent();
        if (curentState != null) {
            String username = curentState.getIdentity().getUserId();
            if (this.log.isDebugEnabled()) {
                this.log.info((Object)("Getting userid: " + username));
            }
            return Response.ok((Object)username, (String)"text/plain").cacheControl(cc).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"exo-domain").build();
    }
}

