/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.server.bean;

import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.RepositoryBackupConfig;
import org.exoplatform.services.jcr.ext.backup.server.bean.response.BackupJobConfig;

public class BackupConfigBean {
    private Integer backupType;
    private Long incrementalJobPeriod;
    private Integer incrementalRepetitionNumber = 0;
    private BackupJobConfig fullBackupJobConfig = new BackupJobConfig();
    private BackupJobConfig incrementalBackupJobConfig = new BackupJobConfig();
    private String backupDir;

    public BackupConfigBean() {
    }

    public BackupConfigBean(Integer backupType, String backupDir) {
        this(backupType, backupDir, 0L);
    }

    public BackupConfigBean(Integer backupType, String backupDir, Long incrementalJobPeriod) {
        this.backupType = backupType;
        this.backupDir = backupDir;
        this.incrementalJobPeriod = incrementalJobPeriod;
    }

    public BackupConfigBean(Integer backupType, String backupDir, Long incrementalJobPeriod, Integer incrementalRepetitionNumber) {
        this.backupType = backupType;
        this.backupDir = backupDir;
        this.incrementalJobPeriod = incrementalJobPeriod;
        this.incrementalRepetitionNumber = incrementalRepetitionNumber;
    }

    public BackupConfigBean(BackupConfig config) {
        this(config.getBackupType(), config.getBackupDir().getAbsolutePath(), config.getIncrementalJobPeriod());
        this.incrementalRepetitionNumber = config.getIncrementalJobNumber();
    }

    public BackupConfigBean(RepositoryBackupConfig config) {
        this(config.getBackupType(), config.getBackupDir().getAbsolutePath(), config.getIncrementalJobPeriod());
        this.incrementalRepetitionNumber = config.getIncrementalJobNumber();
    }

    public Long getIncrementalJobPeriod() {
        return this.incrementalJobPeriod;
    }

    public void setIncrementalJobPeriod(Long incrementalJobPeriod) {
        this.incrementalJobPeriod = incrementalJobPeriod;
    }

    public String getBackupDir() {
        return this.backupDir;
    }

    public void setBackupDir(String backupDir) {
        this.backupDir = backupDir;
    }

    public Integer getBackupType() {
        return this.backupType;
    }

    public void setBackupType(Integer backupType) {
        this.backupType = backupType;
    }

    public Integer getIncrementalRepetitionNumber() {
        return this.incrementalRepetitionNumber;
    }

    public void setIncrementalRepetitionNumber(Integer incrementalRepetitionNumber) {
        this.incrementalRepetitionNumber = incrementalRepetitionNumber;
    }

    public BackupJobConfig getFullBackupJobConfig() {
        return this.fullBackupJobConfig;
    }

    public void setFullBackupJobConfig(BackupJobConfig fullBackupJobConfig) {
        this.fullBackupJobConfig = fullBackupJobConfig;
    }

    public BackupJobConfig getIncrementalBackupJobConfig() {
        return this.incrementalBackupJobConfig;
    }

    public void setIncrementalBackupJobConfig(BackupJobConfig incrementalBackupJobConfig) {
        this.incrementalBackupJobConfig = incrementalBackupJobConfig;
    }
}

