/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import java.io.Serializable;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.User;

public class CacheHandler {
    public static final String MEMBERSHIPTYPE_PREFIX = "mt=";
    public static final String GROUP_PREFIX = "g=";
    public static final String USER_PREFIX = "u=";
    private final ExoCache<Serializable, User> userCache;
    private final ExoCache<Serializable, MembershipType> membershipTypeCache;
    private final ExoCache<Serializable, Membership> membershipCache;
    private final ExoCache<Serializable, Group> groupCache;

    public CacheHandler(CacheService cservice) {
        this.userCache = cservice.getCacheInstance(this.getClass().getName() + "userCache");
        this.membershipTypeCache = cservice.getCacheInstance(this.getClass().getName() + "membershipTypeCache");
        this.groupCache = cservice.getCacheInstance(this.getClass().getName() + "groupCache");
        this.membershipCache = cservice.getCacheInstance(this.getClass().getName() + "membershipCache");
    }

    public void put(Serializable key, Object value, CacheType cacheType) {
        if (cacheType == CacheType.USER) {
            this.userCache.put(key, (Object)((User)value));
        } else if (cacheType == CacheType.GROUP) {
            this.groupCache.put(key, (Object)((Group)value));
        } else if (cacheType == CacheType.MEMBERSHIP) {
            this.membershipCache.put(key, (Object)((Membership)value));
        } else if (cacheType == CacheType.MEMBERSHIPTYPE) {
            this.membershipTypeCache.put(key, (Object)((MembershipType)value));
        }
    }

    public Object get(Serializable key, CacheType cacheType) {
        if (cacheType == CacheType.USER) {
            return this.userCache.get(key);
        }
        if (cacheType == CacheType.GROUP) {
            return this.groupCache.get(key);
        }
        if (cacheType == CacheType.MEMBERSHIP) {
            return this.membershipCache.get(key);
        }
        if (cacheType == CacheType.MEMBERSHIPTYPE) {
            return this.membershipTypeCache.get(key);
        }
        return null;
    }

    public void remove(Serializable key, CacheType cacheType) {
        if (cacheType == CacheType.USER) {
            this.userCache.remove(key);
        } else if (cacheType == CacheType.GROUP) {
            this.groupCache.remove(key);
        } else if (cacheType == CacheType.MEMBERSHIP) {
            try {
                String tKey = ((String)((Object)key)).toUpperCase();
                for (Membership m : this.membershipCache.getCachedObjects()) {
                    String mkey = this.getMembershipKey(m);
                    if (mkey.toUpperCase().indexOf(tKey) < 0) continue;
                    this.membershipCache.remove((Serializable)((Object)mkey));
                }
            }
            catch (Exception exception) {}
        } else if (cacheType == CacheType.MEMBERSHIPTYPE) {
            this.membershipTypeCache.remove(key);
        }
    }

    public String getMembershipKey(Membership m) {
        StringBuilder key = new StringBuilder();
        key.append(GROUP_PREFIX + m.getGroupId());
        key.append(MEMBERSHIPTYPE_PREFIX + m.getMembershipType());
        key.append(USER_PREFIX + m.getUserName());
        return key.toString();
    }

    public String getMembershipKey(String username, String groupId, String type) {
        StringBuilder key = new StringBuilder();
        key.append(GROUP_PREFIX + groupId);
        key.append(MEMBERSHIPTYPE_PREFIX + type);
        key.append(USER_PREFIX + username);
        return key.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CacheType {
        USER,
        GROUP,
        MEMBERSHIP,
        MEMBERSHIPTYPE;

    }
}

