/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import org.jgroups.util.Util;

public class LatencyTest {
    InetAddress GROUP = null;
    int PORT = 7500;

    private void start(boolean sender, boolean local) throws Exception {
        this.GROUP = InetAddress.getByName("228.1.2.3");
        byte[] recv_buf = new byte[2100];
        if (local) {
            MulticastSocket send_sock = new MulticastSocket(this.PORT);
            send_sock.setTrafficClass(8);
            MulticastSocket recv_sock = new MulticastSocket(this.PORT);
            recv_sock.joinGroup(this.GROUP);
            DatagramPacket recv_packet = new DatagramPacket(recv_buf, 0, recv_buf.length);
            for (int i = 0; i < 10; ++i) {
                long start = System.currentTimeMillis();
                byte[] send_buf = Util.objectToByteBuffer(start);
                DatagramPacket send_packet = new DatagramPacket(send_buf, 0, send_buf.length, this.GROUP, this.PORT);
                send_sock.send(send_packet);
                recv_sock.receive(recv_packet);
                start = (Long)Util.objectFromByteBuffer(recv_buf, recv_packet.getOffset(), recv_packet.getLength());
                System.out.println("took " + (System.currentTimeMillis() - start) + " ms");
                Util.sleep(1000L);
            }
            return;
        }
        if (sender) {
            MulticastSocket send_sock = new MulticastSocket(this.PORT);
            send_sock.setTrafficClass(8);
            for (int i = 0; i < 10; ++i) {
                long start = System.currentTimeMillis();
                byte[] send_buf = Util.objectToByteBuffer(start);
                DatagramPacket send_packet = new DatagramPacket(send_buf, 0, send_buf.length, this.GROUP, this.PORT);
                send_sock.send(send_packet);
                Util.sleep(1000L);
            }
        } else {
            MulticastSocket recv_sock = new MulticastSocket(this.PORT);
            recv_sock.joinGroup(this.GROUP);
            DatagramPacket recv_packet = new DatagramPacket(recv_buf, 0, recv_buf.length);
            System.out.println("receiver started");
            while (true) {
                recv_sock.receive(recv_packet);
                long start = (Long)Util.objectFromByteBuffer(recv_buf, recv_packet.getOffset(), recv_packet.getLength());
                System.out.println("took " + (System.currentTimeMillis() - start) + " ms");
            }
        }
    }

    public static void main(String[] args) throws Exception {
        boolean sender = false;
        boolean local = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-sender")) {
                sender = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-local")) {
                local = true;
                continue;
            }
            LatencyTest.help();
            return;
        }
        new LatencyTest().start(sender, local);
    }

    private static void help() {
        System.out.println("LatencyTest [-sender] [-local (overrides -sender)]");
    }
}

