/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.jcr;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryBuilder {
    private StringBuilder queryBuilder;
    private long limit = -1L;
    private long offset = -1L;
    private String[] propertyNames;
    private Session session;
    private final String WHERE = " WHERE";
    public static final String DESC = "DESC";
    public static final String ASC = "ASC";

    public QueryBuilder(Session session) {
        this.session = session;
    }

    public QueryBuilder select(String selector) {
        this.queryBuilder = new StringBuilder();
        this.queryBuilder.append("SELECT * FROM ").append(selector).append(" WHERE");
        return this;
    }

    public QueryBuilder select(String selector, long offset, long limit) {
        this.offset = offset;
        this.limit = limit;
        return this.select(selector);
    }

    public QueryBuilder select(String selector, String property) throws Exception {
        return this.select(selector, new String[]{property});
    }

    public QueryBuilder select(String selector, String property, long offset, long limit) throws Exception {
        this.offset = offset;
        this.limit = limit;
        return this.select(selector, new String[]{property});
    }

    public QueryBuilder select(String selector, String ... properties) throws Exception {
        if (properties == null || properties.length == 0) {
            throw new Exception("Properties must be not null or empty");
        }
        this.propertyNames = properties;
        this.queryBuilder = new StringBuilder();
        this.queryBuilder.append("SELECT ").append(properties[0]);
        for (int i = 1; i < properties.length; ++i) {
            this.queryBuilder.append(",").append(properties[i]);
        }
        this.queryBuilder.append(" FROM ").append(selector).append(" WHERE");
        return this;
    }

    public QueryBuilder select(String selector, long offset, long limit, String ... properties) throws Exception {
        this.offset = offset;
        this.limit = limit;
        return this.select(selector, properties);
    }

    public QueryBuilder group() {
        this.queryBuilder.append(" (");
        return this;
    }

    public QueryBuilder endGroup() {
        this.queryBuilder.append(" )");
        return this;
    }

    public QueryBuilder contains(String property, String value) {
        this.queryBuilder.append(" CONTAINS(").append(property).append(", ").append("'").append(value).append("'").append(")");
        return this;
    }

    public QueryBuilder like(String property, String value) {
        this.queryBuilder.append(" ").append(property).append(" LIKE ").append("'").append(value).append("'");
        return this;
    }

    public QueryBuilder and() {
        this.queryBuilder.append(" AND");
        return this;
    }

    public QueryBuilder or() {
        this.queryBuilder.append(" OR");
        return this;
    }

    public QueryBuilder not() {
        this.queryBuilder.append(" NOT");
        return this;
    }

    public QueryBuilder equal(String property, boolean value) {
        return this.equal(property, String.valueOf(value));
    }

    public QueryBuilder equal(String property, String value) {
        return this.appendComparison(property, "'" + value + "'", "=");
    }

    public QueryBuilder equal(String property, int value) {
        return this.appendComparison(property, value, "=");
    }

    public QueryBuilder greater(String property, int value) {
        return this.appendComparison(property, value, ">");
    }

    public QueryBuilder greaterEqual(String property, int value) {
        return this.appendComparison(property, value, ">=");
    }

    public QueryBuilder less(String property, int value) {
        return this.appendComparison(property, value, "<");
    }

    public QueryBuilder lessEqual(String property, int value) {
        return this.appendComparison(property, value, "<=");
    }

    public QueryBuilder notEqual(String property, int value) {
        return this.appendComparison(property, value, "<>");
    }

    public String lower(String property) {
        return "LOWER(" + property + ")";
    }

    public String upper(String property) {
        return "UPPER(" + property + ")";
    }

    public QueryBuilder isNull(String property) {
        return this.appendComparison(property, "NULL", " IS ");
    }

    public QueryBuilder isNotNull(String property) {
        return this.appendComparison(property, "NULL", " IS NOT ");
    }

    public QueryBuilder orderBy(String property, String orderType) {
        this.revalidateQueryBuilder();
        this.queryBuilder.append(" ORDER BY ").append(property).append(" ").append(orderType);
        return this;
    }

    public long count() throws RepositoryException {
        assert (this.queryBuilder != null);
        QueryResult result = this.query();
        return result.getNodes().getSize();
    }

    public Node findNode() throws Exception {
        List<Node> result = this.exec();
        if (result.size() == 1) {
            return result.get(0);
        }
        if (result.size() > 1) {
            throw new Exception("Query result has more than one node.");
        }
        return null;
    }

    public List<Node> exec() throws RepositoryException {
        assert (this.queryBuilder != null);
        ArrayList<Node> nodes = new ArrayList<Node>();
        QueryResult result = this.query();
        NodeIterator nodeIterator = result.getNodes();
        while (nodeIterator.hasNext()) {
            nodes.add(nodeIterator.nextNode());
        }
        return nodes;
    }

    public List<Value> execProperty() throws Exception {
        if (this.propertyNames == null || this.propertyNames.length == 0) {
            throw new Exception("Property name is not specified");
        }
        QueryResult result = this.query();
        RowIterator rowIterator = result.getRows();
        ArrayList<Value> values = new ArrayList<Value>();
        while (rowIterator.hasNext()) {
            Row row = rowIterator.nextRow();
            values.add(row.getValue(this.propertyNames[0]));
        }
        return values;
    }

    public List<Map<String, Value>> execProperties() throws Exception {
        if (this.propertyNames == null || this.propertyNames.length == 0) {
            throw new Exception("Property names are not specified");
        }
        QueryResult result = this.query();
        RowIterator rowIterator = result.getRows();
        ArrayList<Map<String, Value>> values = new ArrayList<Map<String, Value>>();
        while (rowIterator.hasNext()) {
            Row row = rowIterator.nextRow();
            Hashtable<String, Value> dic = new Hashtable<String, Value>();
            for (int i = 0; i < this.propertyNames.length; ++i) {
                String name = this.propertyNames[i];
                dic.put(name, row.getValue(name));
            }
            values.add(dic);
        }
        return values;
    }

    public String getSQL() {
        assert (this.queryBuilder != null);
        this.revalidateQueryBuilder();
        return this.queryBuilder.toString();
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    private QueryResult query() throws RepositoryException {
        QueryManager queryManager = this.session.getWorkspace().getQueryManager();
        QueryImpl query = (QueryImpl)queryManager.createQuery(this.getSQL(), "sql");
        if (this.offset != -1L & this.limit != -1L) {
            query.setOffset(this.offset);
            query.setLimit(this.limit);
        }
        QueryResult result = query.execute();
        return result;
    }

    private QueryBuilder appendComparison(String property, Object value, String comparator) {
        this.queryBuilder.append(" ").append(property).append(comparator).append(value);
        return this;
    }

    private void revalidateQueryBuilder() {
        String query = this.queryBuilder.toString();
        if (query.endsWith(" WHERE")) {
            query = query.replace(" WHERE", "");
        }
        this.queryBuilder = new StringBuilder(query);
    }
}

