/*
 * Copyright (C) 2003-2010 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.api.calendar;

import java.util.Date;

/**
 * A calendar event.
 */
public interface Event {

	/**
	 * Get the identifier of the event
	 * 
	 * @return
	 */
	String getId();

	/**
	 * The short title for the event.
	 * 
	 * @return
	 */
	String getSummary();

	/**
	 * Details for thhis event
	 * 
	 * @return
	 */
	String getLocation();

	/**
	 * Details for thhis event
	 * 
	 * @return
	 */
	String getDetails();

	/**
	 * Datetime a which the event is scheduled to start
	 * 
	 * @return
	 */
	Date getStartAt();

	/**
	 * Datetime a which the event is scheduled to end
	 * 
	 * @return
	 */
	Date getEndsAt();

}
