/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.autobean.shared;

import com.google.gwt.autobean.shared.AutoBean;
import com.google.gwt.autobean.shared.AutoBeanFactory;
import com.google.gwt.autobean.shared.AutoBeanUtils;
import com.google.gwt.autobean.shared.AutoBeanVisitor;
import com.google.gwt.autobean.shared.Splittable;
import com.google.gwt.autobean.shared.ValueCodex;
import com.google.gwt.autobean.shared.impl.EnumMap;
import com.google.gwt.autobean.shared.impl.LazySplittable;
import com.google.gwt.autobean.shared.impl.StringQuoter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class AutoBeanCodex {
    private final EnumMap enumMap;
    private final AutoBeanFactory factory;
    private final Stack<AutoBean<?>> seen = new Stack();

    public static <T> AutoBean<T> decode(AutoBeanFactory factory, Class<T> clazz, Splittable data) {
        return new AutoBeanCodex(factory).doDecode(clazz, data);
    }

    public static <T> AutoBean<T> decode(AutoBeanFactory factory, Class<T> clazz, String payload) {
        Splittable data = StringQuoter.split(payload);
        return AutoBeanCodex.decode(factory, clazz, data);
    }

    public static void decodeInto(Splittable data, AutoBean<?> bean) {
        new AutoBeanCodex(bean.getFactory()).doDecodeInto(data, bean);
    }

    public static Splittable encode(AutoBean<?> bean) {
        if (bean == null) {
            return LazySplittable.NULL;
        }
        StringBuilder sb = new StringBuilder();
        new AutoBeanCodex(bean.getFactory()).doEncode(sb, bean);
        return new LazySplittable(sb.toString());
    }

    private AutoBeanCodex(AutoBeanFactory factory) {
        this.factory = factory;
        this.enumMap = factory instanceof EnumMap ? (EnumMap)((Object)factory) : null;
    }

    <T> AutoBean<T> doDecode(Class<T> clazz, Splittable data) {
        AutoBean<T> toReturn = this.factory.create(clazz);
        if (toReturn == null) {
            throw new IllegalArgumentException(clazz.getName());
        }
        this.doDecodeInto(data, toReturn);
        return toReturn;
    }

    void doDecodeInto(Splittable data, AutoBean<?> bean) {
        new PropertySetter().decodeInto(data, bean);
    }

    void doEncode(StringBuilder sb, AutoBean<?> bean) {
        PropertyGetter e = new PropertyGetter(sb);
        try {
            bean.accept(e);
        }
        catch (HaltException ex) {
            throw ex.getCause();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValueCoder
    implements Coder {
        private final Class<?> type;

        public ValueCoder(Class<?> type) {
            assert (type.getEnumConstants() == null) : "Should use EnumTypeCodex";
            this.type = type;
        }

        @Override
        public Object decode(Splittable propertyValue) {
            return this.decode(propertyValue.asString());
        }

        public Object decode(String propertyValue) {
            return ValueCodex.decode(this.type, propertyValue);
        }

        @Override
        public void encode(StringBuilder sb, Object value) {
            sb.append(ValueCodex.encode(value).getPayload());
        }
    }

    class SplittableDecoder
    implements Coder {
        SplittableDecoder() {
        }

        public Object decode(Splittable data) {
            return data;
        }

        public void encode(StringBuilder sb, Object value) {
            if (value == null) {
                sb.append("null");
                return;
            }
            sb.append(((Splittable)value).getPayload());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PropertySetter
    extends AutoBeanVisitor {
        private Splittable data;

        PropertySetter() {
        }

        public void decodeInto(Splittable data, AutoBean<?> bean) {
            this.data = data;
            bean.accept(this);
        }

        @Override
        public boolean visitReferenceProperty(String propertyName, AutoBean<?> value, AutoBeanVisitor.PropertyContext ctx) {
            this.decodeProperty(propertyName, ctx);
            return false;
        }

        @Override
        public boolean visitValueProperty(String propertyName, Object value, AutoBeanVisitor.PropertyContext ctx) {
            this.decodeProperty(propertyName, ctx);
            return false;
        }

        protected void decodeProperty(String propertyName, AutoBeanVisitor.PropertyContext ctx) {
            if (!this.data.isNull(propertyName)) {
                CoderCreator pd = new CoderCreator();
                ctx.accept(pd);
                Coder decoder = pd.getCoder();
                Object propertyValue = decoder.decode(this.data.get(propertyName));
                ctx.set(propertyValue);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PropertyGetter
    extends AutoBeanVisitor {
        private boolean first = true;
        private final StringBuilder sb;

        public PropertyGetter(StringBuilder sb) {
            this.sb = sb;
        }

        @Override
        public void endVisit(AutoBean<?> bean, AutoBeanVisitor.Context ctx) {
            this.sb.append("}");
            AutoBeanCodex.this.seen.pop();
        }

        @Override
        public boolean visit(AutoBean<?> bean, AutoBeanVisitor.Context ctx) {
            if (AutoBeanCodex.this.seen.contains(bean)) {
                throw new HaltException(new UnsupportedOperationException("Cycles not supported"));
            }
            AutoBeanCodex.this.seen.push(bean);
            this.sb.append("{");
            return true;
        }

        @Override
        public boolean visitReferenceProperty(String propertyName, AutoBean<?> value, AutoBeanVisitor.PropertyContext ctx) {
            if (value != null) {
                this.encodeProperty(propertyName, value.as(), ctx);
            }
            return false;
        }

        @Override
        public boolean visitValueProperty(String propertyName, Object value, AutoBeanVisitor.PropertyContext ctx) {
            if (value != null && !value.equals(ValueCodex.getUninitializedFieldValue(ctx.getType()))) {
                this.encodeProperty(propertyName, value, ctx);
            }
            return false;
        }

        private void encodeProperty(String propertyName, Object value, AutoBeanVisitor.PropertyContext ctx) {
            CoderCreator pd = new CoderCreator();
            ctx.accept(pd);
            Coder decoder = pd.getCoder();
            if (this.first) {
                this.first = false;
            } else {
                this.sb.append(",");
            }
            this.sb.append(StringQuoter.quote(propertyName));
            this.sb.append(":");
            decoder.encode(this.sb, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ObjectCoder
    implements Coder {
        private final Class<?> type;

        public ObjectCoder(Class<?> type) {
            this.type = type;
        }

        @Override
        public Object decode(Splittable data) {
            AutoBean<?> bean = AutoBeanCodex.this.doDecode(this.type, data);
            return bean == null ? null : bean.as();
        }

        @Override
        public void encode(StringBuilder sb, Object value) {
            if (value == null) {
                sb.append("null");
                return;
            }
            AutoBeanCodex.this.doEncode(sb, AutoBeanUtils.getAutoBean(value));
        }
    }

    class MapCoder
    implements Coder {
        private final Coder keyDecoder;
        private final Coder valueDecoder;

        public MapCoder(Coder valueDecoder, Coder keyDecoder) {
            this.keyDecoder = keyDecoder;
            this.valueDecoder = valueDecoder;
        }

        public Object decode(Splittable data) {
            HashMap<Object, Object> toReturn = new HashMap<Object, Object>();
            if (data.isIndexed()) {
                assert (data.size() == 2) : "Wrong data size: " + data.size();
                Splittable keys = data.get(0);
                Splittable values = data.get(1);
                int j = keys.size();
                for (int i = 0; i < j; ++i) {
                    Object key = keys.isNull(i) ? null : this.keyDecoder.decode(keys.get(i));
                    Object value = values.isNull(i) ? null : this.valueDecoder.decode(values.get(i));
                    toReturn.put(key, value);
                }
            } else {
                ValueCoder keyValueDecoder = (ValueCoder)this.keyDecoder;
                for (String rawKey : data.getPropertyKeys()) {
                    Object key = keyValueDecoder.decode(rawKey);
                    Object value = data.isNull(rawKey) ? null : this.valueDecoder.decode(data.get(rawKey));
                    toReturn.put(key, value);
                }
            }
            return toReturn;
        }

        public void encode(StringBuilder sb, Object value) {
            if (value == null) {
                sb.append("null");
                return;
            }
            Map map = (Map)value;
            boolean isSimpleMap = this.keyDecoder instanceof ValueCoder;
            if (isSimpleMap) {
                boolean first = true;
                sb.append("{");
                for (Map.Entry entry : map.entrySet()) {
                    Object mapValue;
                    Object mapKey = entry.getKey();
                    if (mapKey == null || (mapValue = entry.getValue()) == null) continue;
                    if (first) {
                        first = false;
                    } else {
                        sb.append(",");
                    }
                    this.keyDecoder.encode(sb, mapKey);
                    sb.append(":");
                    this.valueDecoder.encode(sb, mapValue);
                }
                sb.append("}");
            } else {
                ArrayList keys = new ArrayList(map.size());
                ArrayList values = new ArrayList(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    keys.add(entry.getKey());
                    values.add(entry.getValue());
                }
                sb.append("[");
                new CollectionCoder(List.class, this.keyDecoder).encode(sb, keys);
                sb.append(",");
                new CollectionCoder(List.class, this.valueDecoder).encode(sb, values);
                sb.append("]");
            }
        }
    }

    @Deprecated
    static class HaltException
    extends RuntimeException {
        public HaltException(RuntimeException cause) {
            super(cause);
        }

        public RuntimeException getCause() {
            return (RuntimeException)super.getCause();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EnumCoder<E extends Enum<E>>
    implements Coder {
        private final Class<E> type;

        public EnumCoder(Class<E> type) {
            this.type = type;
        }

        @Override
        public Object decode(Splittable data) {
            return AutoBeanCodex.this.enumMap.getEnum(this.type, data.asString());
        }

        @Override
        public void encode(StringBuilder sb, Object value) {
            if (value == null) {
                sb.append("null");
            }
            sb.append(StringQuoter.quote(AutoBeanCodex.this.enumMap.getToken((Enum)value)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CollectionCoder
    implements Coder {
        private final Coder elementDecoder;
        private final Class<?> type;

        public CollectionCoder(Class<?> type, Coder elementDecoder) {
            this.elementDecoder = elementDecoder;
            this.type = type;
        }

        @Override
        public Object decode(Splittable data) {
            AbstractCollection collection;
            if (List.class.equals(this.type)) {
                collection = new ArrayList();
            } else if (Set.class.equals(this.type)) {
                collection = new HashSet();
            } else {
                throw new RuntimeException(this.type.getName());
            }
            int j = data.size();
            for (int i = 0; i < j; ++i) {
                Object element = data.isNull(i) ? null : this.elementDecoder.decode(data.get(i));
                collection.add(element);
            }
            return collection;
        }

        @Override
        public void encode(StringBuilder sb, Object value) {
            if (value == null) {
                sb.append("null");
                return;
            }
            Iterator it = ((Collection)value).iterator();
            sb.append("[");
            if (it.hasNext()) {
                this.elementDecoder.encode(sb, it.next());
                while (it.hasNext()) {
                    sb.append(",");
                    this.elementDecoder.encode(sb, it.next());
                }
            }
            sb.append("]");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CoderCreator
    extends AutoBeanVisitor.ParameterizationVisitor {
        private Stack<Coder> stack = new Stack();

        CoderCreator() {
        }

        @Override
        public void endVisitType(Class<?> type) {
            if (List.class.equals(type) || Set.class.equals(type)) {
                this.stack.push(new CollectionCoder(type, this.stack.pop()));
            } else if (Map.class.equals(type)) {
                this.stack.push(new MapCoder(this.stack.pop(), this.stack.pop()));
            } else if (Splittable.class.equals(type)) {
                this.stack.push(new SplittableDecoder());
            } else if (type.getEnumConstants() != null) {
                EnumCoder decoder = new EnumCoder(type);
                this.stack.push(decoder);
            } else if (ValueCodex.canDecode(type)) {
                this.stack.push(new ValueCoder(type));
            } else {
                this.stack.push(new ObjectCoder(type));
            }
        }

        public Coder getCoder() {
            assert (this.stack.size() == 1) : "Incorrect size: " + this.stack.size();
            return this.stack.pop();
        }
    }

    @Deprecated
    static interface Coder {
        public Object decode(Splittable var1);

        public void encode(StringBuilder var1, Object var2);
    }
}

