/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.security.auth.login.LoginException;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.ow2.bonita.identity.auth.BadLoginOptionException;
import org.ow2.bonita.identity.auth.MissingOptionException;
import org.ow2.bonita.util.ExceptionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTJBossLoginModule
extends UsernamePasswordLoginModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(RESTJBossLoginModule.class);
    private static final String LOGINS_OPTION_NAME = "logins";
    private static final String PASSWORDS_OPTION_NAME = "passwords";
    private static final String ROLES_OPTION_NAME = "roles";
    private List<String> logins;
    private List<String> passwords;
    private List<String> roles;

    public boolean login() throws LoginException {
        this.processUsersPasswordsAndRoles();
        return super.login();
    }

    protected String getUsersPassword() throws LoginException {
        LOGGER.trace("Mot de passe pour " + this.getUsername() + " " + this.passwords.get(this.logins.indexOf(this.getUsername())));
        System.err.println("Mot de passe pour " + this.getUsername() + " " + this.passwords.get(this.logins.indexOf(this.getUsername())));
        return this.passwords.get(this.logins.indexOf(this.getUsername()));
    }

    protected Group[] getRoleSets() throws LoginException {
        String targetUser = this.getUsername();
        SimpleGroup rolesGroup = new SimpleGroup("Roles");
        String userRole = this.roles.get(this.logins.indexOf(targetUser));
        SimplePrincipal simplePrincipal = new SimplePrincipal(userRole);
        rolesGroup.addMember((Principal)simplePrincipal);
        ArrayList<SimpleGroup> groups = new ArrayList<SimpleGroup>();
        groups.add(rolesGroup);
        System.err.println("Role for " + targetUser + " is " + userRole);
        Group[] roleSets = new Group[groups.size()];
        groups.toArray(roleSets);
        return roleSets;
    }

    private void processUsersPasswordsAndRoles() throws BadLoginOptionException, MissingOptionException {
        if (this.logins == null) {
            String loginList = (String)this.options.get(LOGINS_OPTION_NAME);
            String passwordList = (String)this.options.get(PASSWORDS_OPTION_NAME);
            String rolesList = (String)this.options.get(ROLES_OPTION_NAME);
            if (loginList == null) {
                String message = ExceptionManager.getInstance().getFullMessage("bi_PLM_1", new Object[]{LOGINS_OPTION_NAME});
                throw new MissingOptionException("bi_PLM_1", message);
            }
            if (passwordList == null) {
                String message = ExceptionManager.getInstance().getFullMessage("bi_PLM_2", new Object[]{PASSWORDS_OPTION_NAME});
                throw new MissingOptionException("bi_PLM_2", message);
            }
            if (rolesList == null) {
                String message = ExceptionManager.getInstance().getFullMessage("bi_PLM_7", new Object[]{ROLES_OPTION_NAME});
                throw new MissingOptionException("bi_PLM_7", message);
            }
            StringTokenizer loginTokenizer = new StringTokenizer(loginList, ",");
            StringTokenizer passwordTokenizer = new StringTokenizer(passwordList, ",");
            StringTokenizer roleTokenizer = new StringTokenizer(rolesList, ",");
            if (loginTokenizer.countTokens() != passwordTokenizer.countTokens()) {
                String message = ExceptionManager.getInstance().getFullMessage("bi_PLM_8", new Object[0]);
                throw new BadLoginOptionException(message);
            }
            if (loginTokenizer.countTokens() != roleTokenizer.countTokens()) {
                String message = ExceptionManager.getInstance().getFullMessage("bi_PLM_8", new Object[0]);
                throw new BadLoginOptionException(message);
            }
            this.logins = new ArrayList<String>();
            this.passwords = new ArrayList<String>();
            this.roles = new ArrayList<String>();
            while (loginTokenizer.hasMoreTokens()) {
                String name = loginTokenizer.nextToken().trim();
                if (this.logins.contains(name)) {
                    String message = ExceptionManager.getInstance().getFullMessage("bi_PLM_4", new Object[]{name});
                    throw new BadLoginOptionException(message);
                }
                String password = passwordTokenizer.nextToken().trim();
                String role = roleTokenizer.nextToken().trim();
                this.logins.add(name);
                this.passwords.add(password);
                this.roles.add(role);
            }
        }
    }
}

