/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.client.impl;

import com.google.gwt.core.client.impl.AsyncFragmentLoader;
import com.google.gwt.xhr.client.ReadyStateChangeHandler;
import com.google.gwt.xhr.client.XMLHttpRequest;

public class XhrLoadingStrategy
implements AsyncFragmentLoader.LoadingStrategy {
    static final String HTTP_GET = "GET";
    static final int HTTP_STATUS_NON_HTTP = 0;
    static final int HTTP_STATUS_OK = 200;
    private static final int MAX_LOG_LENGTH = 200;
    private static final int MAX_RETRY_COUNT = 3;

    public void startLoadingFragment(int fragment, AsyncFragmentLoader.LoadTerminatedHandler loadErrorHandler) {
        String url = this.gwtStartLoadingFragment(fragment, loadErrorHandler);
        if (url == null) {
            return;
        }
        RequestData request = new RequestData(url, loadErrorHandler);
        this.tryLoad(request);
    }

    protected MockableXMLHttpRequest createXhr() {
        return new DelegatingXMLHttpRequest(XMLHttpRequest.create());
    }

    protected native void gwtInstallCode(String var1);

    protected native String gwtStartLoadingFragment(int var1, AsyncFragmentLoader.LoadTerminatedHandler var2);

    protected void onLoadError(RequestData request, Throwable e, boolean mayRetry) {
        if (mayRetry) {
            ++request.retryCount;
            if (request.retryCount < 3) {
                this.tryLoad(request);
                return;
            }
        }
        request.errorHandler.loadTerminated(e);
    }

    protected void tryLoad(final RequestData request) {
        final MockableXMLHttpRequest xhr = this.createXhr();
        xhr.open(HTTP_GET, request.url);
        if (request.retryCount > 0) {
            xhr.setRequestHeader("Cache-Control", "no-cache");
        }
        xhr.setOnReadyStateChange(new ReadyStateChangeHandler(){

            public void onReadyStateChange(XMLHttpRequest ignored) {
                if (xhr.getReadyState() == 4) {
                    xhr.clearOnReadyStateChange();
                    if ((xhr.getStatus() == 200 || xhr.getStatus() == 0) && xhr.getResponseText() != null && xhr.getResponseText().length() != 0) {
                        try {
                            XhrLoadingStrategy.this.gwtInstallCode(xhr.getResponseText());
                        }
                        catch (RuntimeException e) {
                            String textIntro = xhr.getResponseText();
                            if (textIntro != null && textIntro.length() > 200) {
                                textIntro = textIntro.substring(0, 200) + "...";
                            }
                            XhrLoadingStrategy.this.onLoadError(request, new AsyncFragmentLoader.HttpInstallFailure(request.url, textIntro, e), false);
                        }
                    } else {
                        XhrLoadingStrategy.this.onLoadError(request, new AsyncFragmentLoader.HttpDownloadFailure(request.url, xhr.getStatus(), xhr.getStatusText()), true);
                    }
                }
            }
        });
        xhr.send();
    }

    protected class RequestData {
        String url;
        int retryCount;
        AsyncFragmentLoader.LoadTerminatedHandler errorHandler = null;

        public RequestData(String url, AsyncFragmentLoader.LoadTerminatedHandler errorHandler) {
            this.url = url;
            this.errorHandler = errorHandler;
            this.retryCount = 0;
        }
    }

    static interface MockableXMLHttpRequest {
        public void clearOnReadyStateChange();

        public int getReadyState();

        public String getResponseText();

        public int getStatus();

        public String getStatusText();

        public void open(String var1, String var2);

        public void send();

        public void setOnReadyStateChange(ReadyStateChangeHandler var1);

        public void setRequestHeader(String var1, String var2);
    }

    class DelegatingXMLHttpRequest
    implements MockableXMLHttpRequest {
        private final XMLHttpRequest delegate;

        public DelegatingXMLHttpRequest(XMLHttpRequest xmlHttpRequest) {
            this.delegate = xmlHttpRequest;
        }

        public void clearOnReadyStateChange() {
            this.delegate.clearOnReadyStateChange();
        }

        public int getReadyState() {
            return this.delegate.getReadyState();
        }

        public String getResponseText() {
            return this.delegate.getResponseText();
        }

        public int getStatus() {
            return this.delegate.getStatus();
        }

        public String getStatusText() {
            return this.delegate.getStatusText();
        }

        public void open(String method, String url) {
            this.delegate.open(method, url);
        }

        public void send() {
            this.delegate.send();
        }

        public void setOnReadyStateChange(ReadyStateChangeHandler handler) {
            this.delegate.setOnReadyStateChange(handler);
        }

        public void setRequestHeader(String header, String value) {
            this.delegate.setRequestHeader(header, value);
        }
    }
}

