/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.datepicker.client;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.datepicker.client.CalendarUtil;
import java.util.Date;

public class CalendarModel {
    public static final int WEEKS_IN_MONTH = 6;
    public static final int DAYS_IN_WEEK = 7;
    private static final String[] dayOfWeekNames = new String[7];
    private static String[] dayOfMonthNames = new String[32];
    private final Date currentMonth = new Date();

    public CalendarModel() {
        int i;
        CalendarUtil.setToFirstDayOfMonth(this.currentMonth);
        Date date = new Date();
        for (i = 1; i <= 7; ++i) {
            date.setDate(i);
            int dayOfWeek = date.getDay();
            CalendarModel.dayOfWeekNames[dayOfWeek] = this.getDayOfWeekFormatter().format(date);
        }
        date.setMonth(0);
        for (i = 1; i < 32; ++i) {
            date.setDate(i);
            CalendarModel.dayOfMonthNames[i] = this.getDayOfMonthFormatter().format(date);
        }
    }

    public String formatCurrentMonth() {
        return this.getMonthAndYearFormatter().format(this.currentMonth);
    }

    public String formatDayOfMonth(Date date) {
        return dayOfMonthNames[date.getDate()];
    }

    public String formatDayOfWeek(int dayInWeek) {
        return dayOfWeekNames[dayInWeek];
    }

    public Date getCurrentFirstDayOfFirstWeek() {
        int start;
        int wkDayOfMonth1st = this.currentMonth.getDay();
        if (wkDayOfMonth1st == (start = CalendarUtil.getStartingDayOfWeek())) {
            return new Date(this.currentMonth.getTime());
        }
        Date d = new Date(this.currentMonth.getTime());
        int offset = wkDayOfMonth1st - start > 0 ? wkDayOfMonth1st - start : 7 - (start - wkDayOfMonth1st);
        CalendarUtil.addDaysToDate(d, -offset);
        return d;
    }

    public Date getCurrentMonth() {
        return this.currentMonth;
    }

    public boolean isInCurrentMonth(Date date) {
        return this.currentMonth.getMonth() == date.getMonth();
    }

    public void setCurrentMonth(Date currentDate) {
        this.currentMonth.setYear(currentDate.getYear());
        this.currentMonth.setMonth(currentDate.getMonth());
    }

    public void shiftCurrentMonth(int deltaMonths) {
        CalendarUtil.addMonthsToDate(this.currentMonth, deltaMonths);
        this.refresh();
    }

    protected DateTimeFormat getDayOfMonthFormatter() {
        return DateTimeFormat.getFormat(DateTimeFormat.PredefinedFormat.DAY);
    }

    protected DateTimeFormat getDayOfWeekFormatter() {
        return DateTimeFormat.getFormat("ccccc");
    }

    protected DateTimeFormat getMonthAndYearFormatter() {
        return DateTimeFormat.getFormat(DateTimeFormat.PredefinedFormat.YEAR_MONTH_ABBR);
    }

    protected void refresh() {
    }
}

