/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadget.services.Invitations;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.platform.gadget.services.Invitations.Relation;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/gadgets/social-inbox/v1")
@Produces(value={"application/json"})
public class InvitationsRestServices
implements ResourceContainer {
    private static final CacheControl cacheControl;

    @GET
    @Path(value="contacts/{identityId}/pending")
    public Response contactsPendingRequests(@PathParam(value="identityId") String identityId) {
        IdentityManager identityManager = (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
        Identity identity = identityManager.getOrCreateIdentity("organization", identityId);
        if (identity == null) {
            return Response.ok((Object)("identity null for " + identityId), (String)"application/json").cacheControl(cacheControl).build();
        }
        RelationshipManager relationshipManager = (RelationshipManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RelationshipManager.class);
        List relations = relationshipManager.getIncoming(identity);
        ArrayList<Object> liste = new ArrayList<Object>();
        for (Relationship relation : relations) {
            Relation rel = new Relation();
            Identity contactIdentity = relation.getSender();
            Profile profile = contactIdentity.getProfile();
            rel.setRelationshipId(contactIdentity.getRemoteId());
            rel.setRequesterName(profile.getFullName());
            rel.setPosition(profile.getPosition());
            rel.setAvatarUrl(profile.getAvatarUrl());
            liste.add(rel);
        }
        return this.renderJSON(liste);
    }

    @GET
    @Path(value="spaces/{userId}/pending")
    public Response invited(@PathParam(value="userId") String userId) {
        SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
        List spaces = new ArrayList();
        try {
            spaces = spaceService.getInvitedSpaces(userId);
        }
        catch (Exception e) {
            // empty catch block
        }
        ArrayList<Object> listData = new ArrayList<Object>();
        for (Space space : spaces) {
            listData.add(space);
        }
        return this.renderJSON(listData);
    }

    private Response renderJSON(List<Object> liste) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        MessageBean data = new MessageBean();
        data.setData(liste);
        return Response.ok((Object)data, (String)"application/json").cacheControl(cacheControl).build();
    }

    static {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MessageBean {
        private List<Object> data;

        public void setData(List<Object> list) {
            this.data = list;
        }

        public List<Object> getData() {
            return this.data;
        }
    }
}

