/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import java.util.Collection;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.ExoProperties;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.common.space.SpaceCustomizationService;
import org.exoplatform.services.deployment.DeploymentDescriptor;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.api.SpaceStorage;

public class SpaceUpgradePlugin
extends UpgradeProductPlugin {
    private final OrganizationService service;
    private final SpaceStorage spaceStorage;
    private final SpaceCustomizationService spaceCustomizationService;
    private final ExoProperties welcomeSCVCustomPreferences;
    private final DeploymentDescriptor deploymentDescriptor;
    private static final Log LOG = ExoLogger.getLogger(SpaceUpgradePlugin.class);

    public SpaceUpgradePlugin(SpaceCustomizationService spaceCustomizationService, OrganizationService organizationService, SpaceStorage spaceStorage, InitParams initParams) {
        super(initParams);
        this.service = organizationService;
        this.spaceStorage = spaceStorage;
        this.spaceCustomizationService = spaceCustomizationService;
        this.welcomeSCVCustomPreferences = new ExoProperties();
        this.welcomeSCVCustomPreferences.put((Object)"nodeIdentifier", (Object)"/Groups{spaceGroupId}/SharedData/welcome");
        this.deploymentDescriptor = new DeploymentDescriptor();
        this.deploymentDescriptor.setCleanupPublication(Boolean.valueOf(true));
        this.deploymentDescriptor.setSourcePath("war:/conf/office-extension/social/artifacts/SpaceWelcome.xml");
        DeploymentDescriptor.Target target = new DeploymentDescriptor.Target();
        target.setNodePath("/SharedData");
        target.setWorkspace("collaboration");
        this.deploymentDescriptor.setTarget(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            GroupHandler groupHandler = this.service.getGroupHandler();
            Group spaces = this.service.getGroupHandler().findGroupById("/spaces");
            Collection groups = groupHandler.findGroups(spaces);
            SessionProvider sessionProvider = SessionProvider.createSystemProvider();
            for (Group group : groups) {
                Space space = this.spaceStorage.getSpaceByGroupId(group.getId());
                this.spaceCustomizationService.createSpaceHomePage(space.getPrettyName(), group.getId(), this.welcomeSCVCustomPreferences);
                this.spaceCustomizationService.deployContentToSpaceDrive(sessionProvider, group.getId(), this.deploymentDescriptor);
            }
        }
        catch (Exception e) {
            LOG.info((Object)("Error during spaces migration : " + e.getMessage()), (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public boolean shouldProceedToUpgrade(String oldVersion, String newVersion) {
        return true;
    }
}

