/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.organization.integration.OrganizationIntegrationService;
import org.exoplatform.platform.organization.integration.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.idm.MembershipImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeOrganizationIntegrationDataPlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(UpgradeOrganizationIntegrationDataPlugin.class);
    private static final String SPECIAL_CHARACTER_REPLACEMENT = "___";
    private static final String MEMBERSHIP_SEPARATOR = "---";
    private static final String ORGANIZATION_INITIALIZATIONS = "OrganizationIntegrationService";
    private static final String USERS_FOLDER = "users";
    private static final String GROUPS_FOLDER = "groups";
    private static final String MEMBERSHIPS_FOLDER = "memberships";
    private static final String PROFILES_FOLDER = "profiles";
    private RepositoryService repositoryService;
    private DataDistributionManager dataDistributionManager;
    private OrganizationIntegrationService organizationIntegrationService;

    public UpgradeOrganizationIntegrationDataPlugin(DataDistributionManager dataDistributionManager, RepositoryService repositoryService, InitParams initParams) {
        super(initParams);
        this.repositoryService = repositoryService;
        this.dataDistributionManager = dataDistributionManager;
    }

    public boolean shouldProceedToUpgrade(String previousVersion, String newVersion) {
        try {
            this.organizationIntegrationService = this.getService(OrganizationIntegrationService.class);
        }
        catch (Exception E) {
            LOG.error((Object)"Cannot load OrganizationIntegrationService!", (Throwable)E);
        }
        if (this.organizationIntegrationService.isSynchronizeGroups()) {
            LOG.warn((Object)"Caution: synchronization of groups is activated for OrganizationIntegrationService. It shouldn't be enabled when upgrading!");
        }
        Session session = null;
        try {
            Node homeNode;
            session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
            boolean isUpgrade = false;
            isUpgrade = session.itemExists(Util.HOME_PATH);
            if (isUpgrade && (isUpgrade = (homeNode = (Node)session.getItem(Util.HOME_PATH)).hasNode(ORGANIZATION_INITIALIZATIONS))) {
                Node orgIntegrationParentNode = homeNode.getNode(ORGANIZATION_INITIALIZATIONS);
                isUpgrade = orgIntegrationParentNode.hasNode(GROUPS_FOLDER);
            }
            boolean bl = isUpgrade;
            return bl;
        }
        catch (RepositoryException exception) {
            throw new RuntimeException(exception);
        }
        finally {
            if (session != null) {
                session.logout();
                session = null;
            }
        }
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        Session session = null;
        try {
            session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
            Util.init((Session)session);
            Node homeNode = (Node)session.getItem(Util.HOME_PATH);
            Node orgIntegrationParentNode = homeNode.getNode(ORGANIZATION_INITIALIZATIONS);
            this.migrateUsers(session, orgIntegrationParentNode);
            this.migrateProfiles(session, orgIntegrationParentNode);
            this.migrateGroups(session, orgIntegrationParentNode);
            this.migrateMemberships(session, orgIntegrationParentNode);
            orgIntegrationParentNode.remove();
            session.save();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            if (session != null) {
                session.logout();
                session = null;
            }
        }
    }

    private void migrateUsers(Session session, Node orgIntegrationParentNode) throws Exception {
        Node usersNode = orgIntegrationParentNode.getNode(USERS_FOLDER);
        Map<String, String> userMap = this.getNodeList(usersNode);
        for (String username : userMap.keySet()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Begin migration for [USER]: " + username));
            }
            if (!Util.hasUserFolder((DataDistributionManager)this.dataDistributionManager, (Session)session, (String)username)) {
                Util.createUserFolder((DataDistributionManager)this.dataDistributionManager, (Session)session, (String)username);
            }
            Node node = (Node)session.getItem(userMap.get(username));
            node.remove();
            session.save();
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Migration successfully finished for [USER]: " + username));
        }
        if (usersNode.hasNodes()) {
            throw new IllegalStateException(usersNode.getPath() + " : users parent node should be empty after migration.");
        }
        usersNode.remove();
        session.save();
    }

    private void migrateProfiles(Session session, Node orgIntegrationParentNode) throws Exception {
        Node profilesNode = orgIntegrationParentNode.getNode(PROFILES_FOLDER);
        Map<String, String> profileMap = this.getNodeList(profilesNode);
        for (String username : profileMap.keySet()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Begin migration for [PROFILE]: " + username));
            }
            if (!Util.hasProfileFolder((DataDistributionManager)this.dataDistributionManager, (Session)session, (String)username)) {
                Util.createProfileFolder((DataDistributionManager)this.dataDistributionManager, (Session)session, (String)username);
            }
            Node node = (Node)session.getItem(profileMap.get(username));
            node.remove();
            session.save();
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Migration successfully finished for [PROFILE]: " + username));
        }
        if (profilesNode.hasNodes()) {
            throw new IllegalStateException(profilesNode.getPath() + " : profiles parent node should be empty after migration.");
        }
        profilesNode.remove();
        session.save();
    }

    private void migrateGroups(Session session, Node orgIntegrationParentNode) throws Exception {
        Node groupsNode = orgIntegrationParentNode.getNode(GROUPS_FOLDER);
        Map<String, String> groupMap = this.getNodeList(groupsNode);
        for (String groupId : groupMap.keySet()) {
            String originalGroupId;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Begin migration for [GROUP]: " + groupId));
            }
            if (!Util.hasGroupFolder((DataDistributionManager)this.dataDistributionManager, (Session)session, (String)(originalGroupId = groupId.replace(SPECIAL_CHARACTER_REPLACEMENT, "/")))) {
                Util.createGroupFolder((DataDistributionManager)this.dataDistributionManager, (Session)session, (String)originalGroupId);
            }
            Node node = (Node)session.getItem(groupMap.get(groupId));
            node.remove();
            session.save();
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Migration successfully finished for [GROUP]: " + originalGroupId));
        }
        if (groupsNode.hasNodes()) {
            throw new IllegalStateException(groupsNode.getPath() + " : groups parent node should be empty after migration.");
        }
        groupsNode.remove();
        session.save();
    }

    private void migrateMemberships(Session session, Node orgIntegrationParentNode) throws Exception {
        Node membershipsNode = orgIntegrationParentNode.getNode(MEMBERSHIPS_FOLDER);
        Map<String, String> membershipMap = this.getNodeList(membershipsNode);
        for (String membershipFolderName : membershipMap.keySet()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Begin migration for [MEMBERSHIP]: " + membershipFolderName));
            }
            String[] membershipIdElements = membershipFolderName.split(MEMBERSHIP_SEPARATOR);
            MembershipImpl membership = new MembershipImpl();
            membership.setGroupId(membershipIdElements[0].replace(SPECIAL_CHARACTER_REPLACEMENT, "/"));
            membership.setMembershipType(membershipIdElements[1].replace(SPECIAL_CHARACTER_REPLACEMENT, "*"));
            membership.setUserName(membershipIdElements[2]);
            if (!Util.hasMembershipFolder((DataDistributionManager)this.dataDistributionManager, (Session)session, (Membership)membership)) {
                Util.createMembershipFolder((DataDistributionManager)this.dataDistributionManager, (Session)session, (Membership)membership);
            }
            Node node = (Node)session.getItem(membershipMap.get(membershipFolderName));
            node.remove();
            session.save();
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Migration successfully finished for [MEMBERSHIP]: " + membership.getId()));
        }
        if (membershipsNode.hasNodes()) {
            throw new IllegalStateException(membershipsNode.getPath() + " : memberships parent node should be empty after migration.");
        }
        membershipsNode.remove();
        session.save();
    }

    private Map<String, String> getNodeList(Node parentNode) throws Exception {
        NodeIterator nodeIterator = parentNode.getNodes();
        HashMap<String, String> nodeNameList = new HashMap<String, String>();
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.nextNode();
            nodeNameList.put(node.getName(), node.getPath());
        }
        return nodeNameList;
    }

    protected <T> T getService(Class<T> clazz) {
        return clazz.cast(PortalContainer.getInstance().getComponentInstanceOfType(clazz));
    }
}

