/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.jaas.weblogic.authentication;

import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import org.exoplatform.services.security.jaas.weblogic.authentication.ExoAuthenticatorMBean;
import weblogic.management.security.ProviderMBean;
import weblogic.security.spi.AuthenticationProviderV2;
import weblogic.security.spi.IdentityAsserterV2;
import weblogic.security.spi.PrincipalValidator;
import weblogic.security.spi.SecurityServices;

public class ExoAuthenticationProviderImpl
implements AuthenticationProviderV2 {
    private String description = "eXoPlatform authentication provider";
    private AppConfigurationEntry.LoginModuleControlFlag controlFlag;
    private String loginModuleClass;

    public String getDescription() {
        return this.description;
    }

    public void initialize(ProviderMBean providerMBean, SecurityServices securityServices) {
        String strControlFlag;
        ExoAuthenticatorMBean exoAuthenticatorMBean = (ExoAuthenticatorMBean)providerMBean;
        this.loginModuleClass = exoAuthenticatorMBean.getLoginModuleClass();
        if (!exoAuthenticatorMBean.getDescription().equals("")) {
            this.description = exoAuthenticatorMBean.getDescription() + "\n" + exoAuthenticatorMBean.getVersion();
        }
        if ((strControlFlag = exoAuthenticatorMBean.getControlFlag()).equalsIgnoreCase("REQUIRED")) {
            this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        } else if (strControlFlag.equalsIgnoreCase("OPTIONAL")) {
            this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        } else if (strControlFlag.equalsIgnoreCase("REQUISITE")) {
            this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        } else if (strControlFlag.equalsIgnoreCase("SUFFICIENT")) {
            this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        } else {
            throw new IllegalArgumentException("invalid flag value" + strControlFlag);
        }
    }

    public AppConfigurationEntry getAssertionModuleConfiguration() {
        return null;
    }

    public IdentityAsserterV2 getIdentityAsserter() {
        return null;
    }

    public AppConfigurationEntry getLoginModuleConfiguration() {
        return new AppConfigurationEntry(this.loginModuleClass, this.controlFlag, new HashMap());
    }

    public PrincipalValidator getPrincipalValidator() {
        return null;
    }

    public void shutdown() {
    }
}

