/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadget.services.LoginHistory;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.platform.gadget.services.LoginHistory.LastLoginBean;
import org.exoplatform.platform.gadget.services.LoginHistory.LoginCounterBean;
import org.exoplatform.platform.gadget.services.LoginHistory.LoginHistoryBean;
import org.exoplatform.platform.gadget.services.LoginHistory.LoginHistoryPlugin;
import org.exoplatform.platform.gadget.services.LoginHistory.LoginHistoryService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoginHistoryServiceImpl
implements LoginHistoryService {
    private static final Log log = ExoLogger.getLogger(LoginHistoryServiceImpl.class);
    private static String HOME = "exo:LoginHistoryHome";
    private static String LOGIN_HISTORY = "loginHistory";
    private static String LOGIN_COUNTER = "loginCounter";
    private static int MAX_NUM_OF_LOGIN_HISTORY_ENTRIES = 0;
    private static int DAYS_FOR_KEEPING_USER_STATISTIC = 0;
    private static int DAYS_FOR_KEEPING_GLOBAL_STATISTIC = 0;
    private static long DAY_IN_MILLISEC = 86400000L;
    private RepositoryService _repoService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LoginHistoryServiceImpl(RepositoryService repoService) throws Exception {
        this._repoService = repoService;
        if (this._repoService != null) {
            SessionProvider sProvider = SessionProvider.createSystemProvider();
            try {
                ManageableRepository currentRepo = this._repoService.getCurrentRepository();
                Session session = sProvider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
                Node rootNode = session.getRootNode();
                if (rootNode.hasNode(HOME)) return;
                Node homeNode = rootNode.addNode(HOME, "exo:LoginHisSvc_loginHistoryService");
                rootNode.save();
                Node globalLoginCounterNode = homeNode.addNode("AllUsers", "exo:LoginHisSvc_globalLoginCounter");
                globalLoginCounterNode.setProperty("exo:LoginHisSvc_globalLoginCounter_lastIndex", 0L);
                homeNode.save();
                return;
            }
            catch (Exception e) {
                log.debug((Object)("Error in LoginHistoryServiceImpl's constructor: " + e.getMessage()), (Throwable)e);
                throw e;
            }
            finally {
                sProvider.close();
            }
        } else {
            log.warn((Object)"RepositoryService is null");
        }
    }

    public void addConfiguration(LoginHistoryPlugin plugin) {
        InitParams initParams = plugin.getInitParams();
        if (initParams != null) {
            ValueParam DaysForKeepingGlobalStatistic;
            ValueParam DaysForKeepingUserStatistic;
            ValueParam MaxNumOfUserLoginHistoryEntries = initParams.getValueParam("MaxNumOfUserLoginHistoryEntries");
            if (MaxNumOfUserLoginHistoryEntries != null) {
                MAX_NUM_OF_LOGIN_HISTORY_ENTRIES = Integer.parseInt(MaxNumOfUserLoginHistoryEntries.getValue());
            }
            if ((DaysForKeepingUserStatistic = initParams.getValueParam("DaysForKeepingUserStatistic")) != null) {
                DAYS_FOR_KEEPING_USER_STATISTIC = Integer.parseInt(DaysForKeepingUserStatistic.getValue());
            }
            if ((DaysForKeepingGlobalStatistic = initParams.getValueParam("DaysForKeepingGlobalStatistic")) != null) {
                DAYS_FOR_KEEPING_GLOBAL_STATISTIC = Integer.parseInt(DaysForKeepingGlobalStatistic.getValue());
            }
        }
    }

    @Override
    public long getLastLogin(String userId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Session session = this.getSession(sProvider);
            Node homeNode = session.getRootNode().getNode(HOME);
            long l = !homeNode.hasNode(userId) ? 0L : homeNode.getNode(userId).getProperty("exo:LoginHisSvc_lastLogin").getLong();
            return l;
        }
        catch (Exception e) {
            log.debug((Object)("Error while retrieving " + userId + "'s last login: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            sProvider.close();
        }
    }

    @Override
    public List<LastLoginBean> getLastLogins(int numItems, String userIdFilter) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Session session = this.getSession(sProvider);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String sqlStatement = "SELECT * FROM exo:LoginHisSvc_userProfile WHERE exo:LoginHisSvc_userId LIKE '%" + userIdFilter + "%' " + "ORDER BY exo:LoginHisSvc_lastLogin DESC";
            QueryImpl query = (QueryImpl)queryManager.createQuery(sqlStatement, "sql");
            query.setLimit((long)numItems);
            QueryResult result = query.execute();
            NodeIterator nodeIterator = result.getNodes();
            ArrayList<LastLoginBean> lastLogins = new ArrayList<LastLoginBean>();
            ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                LastLoginBean lastLoginBean = new LastLoginBean();
                String userId = node.getName();
                String userName = forumService.getUserInfo(userId).getFullName();
                lastLoginBean.setUserId(userId);
                lastLoginBean.setUserName(userName.isEmpty() ? userId : userName);
                lastLoginBean.setLastLogin(node.getProperty("exo:LoginHisSvc_lastLogin").getLong());
                lastLoginBean.setBeforeLastLogin(node.getProperty("exo:LoginHisSvc_beforeLastLogin").getLong());
                lastLogins.add(lastLoginBean);
            }
            ArrayList<LastLoginBean> arrayList = lastLogins;
            return arrayList;
        }
        catch (Exception e) {
            log.debug((Object)("Error while retrieving last logins: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            sProvider.close();
        }
    }

    @Override
    public void addLoginHistoryEntry(String userId, long loginTime) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node globalLoginCounter_loginDateNode;
            Node loginCounter_loginDateNode;
            Node loginCounterNode;
            Node loginHistoryNode;
            Node userNode;
            Session session = this.getSession(sProvider);
            Node homeNode = session.getRootNode().getNode(HOME);
            if (!homeNode.hasNode(userId)) {
                userNode = homeNode.addNode(userId, "exo:LoginHisSvc_userProfile");
                userNode.setProperty("exo:LoginHisSvc_userId", userId);
                userNode.setProperty("exo:LoginHisSvc_lastLogin", 0L);
                userNode.setProperty("exo:LoginHisSvc_beforeLastLogin", 0L);
                homeNode.save();
                loginHistoryNode = userNode.addNode(LOGIN_HISTORY, "exo:LoginHisSvc_loginHistory");
                loginHistoryNode.setProperty("exo:LoginHisSvc_loginHistory_lastIndex", 0L);
                loginCounterNode = userNode.addNode(LOGIN_COUNTER, "exo:LoginHisSvc_loginCounter");
                loginCounterNode.setProperty("exo:LoginHisSvc_loginCounter_lastIndex", 0L);
                userNode.save();
            } else {
                userNode = homeNode.getNode(userId);
            }
            userNode.setProperty("exo:LoginHisSvc_beforeLastLogin", userNode.getProperty("exo:LoginHisSvc_lastLogin").getLong());
            userNode.setProperty("exo:LoginHisSvc_lastLogin", loginTime);
            loginHistoryNode = userNode.getNode("loginHistory");
            long loginHistory_lastIndex = loginHistoryNode.getProperty("exo:LoginHisSvc_loginHistory_lastIndex").getLong();
            Node loginHistory_loginTimeNode = loginHistoryNode.addNode(Long.toString(++loginHistory_lastIndex), "exo:LoginHisSvc_loginHistoryItem");
            loginHistory_loginTimeNode.setProperty("exo:LoginHisSvc_loginHistoryItem_id", loginHistory_lastIndex);
            loginHistory_loginTimeNode.setProperty("exo:LoginHisSvc_loginHistoryItem_userId", userId);
            loginHistory_loginTimeNode.setProperty("exo:LoginHisSvc_loginHistoryItem_loginTime", loginTime);
            if (MAX_NUM_OF_LOGIN_HISTORY_ENTRIES > 0 && loginHistory_lastIndex > (long)MAX_NUM_OF_LOGIN_HISTORY_ENTRIES) {
                QueryManager queryManager = session.getWorkspace().getQueryManager();
                String sqlStatement = "SELECT * FROM exo:LoginHisSvc_loginHistoryItem WHERE exo:LoginHisSvc_loginHistoryItem_userId = '" + userId + "' " + "AND exo:LoginHisSvc_loginHistoryItem_id <= " + Long.toString(loginHistory_lastIndex - (long)MAX_NUM_OF_LOGIN_HISTORY_ENTRIES);
                QueryImpl query = (QueryImpl)queryManager.createQuery(sqlStatement, "sql");
                QueryResult result = query.execute();
                NodeIterator nodeIterator = result.getNodes();
                while (nodeIterator.hasNext()) {
                    Node node = nodeIterator.nextNode();
                    node.remove();
                }
            }
            loginHistoryNode.setProperty("exo:LoginHisSvc_loginHistory_lastIndex", loginHistory_lastIndex);
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(loginTime);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            String loginDate = Long.toString(cal.getTimeInMillis());
            loginCounterNode = userNode.getNode("loginCounter");
            long loginCounter_lastIndex = loginCounterNode.getProperty("exo:LoginHisSvc_loginCounter_lastIndex").getLong();
            if (!loginCounterNode.hasNode(loginDate)) {
                loginCounter_loginDateNode = loginCounterNode.addNode(loginDate, "exo:LoginHisSvc_loginCounterItem");
                loginCounter_loginDateNode.setProperty("exo:LoginHisSvc_loginCounterItem_id", ++loginCounter_lastIndex);
                loginCounter_loginDateNode.setProperty("exo:LoginHisSvc_loginCounterItem_userId", userId);
                loginCounter_loginDateNode.setProperty("exo:LoginHisSvc_loginCounterItem_loginDate", Long.parseLong(loginDate));
                loginCounter_loginDateNode.setProperty("exo:LoginHisSvc_loginCounterItem_loginCount", 1L);
            } else {
                loginCounter_loginDateNode = loginCounterNode.getNode(loginDate);
                long loginCount = loginCounter_loginDateNode.getProperty("exo:LoginHisSvc_loginCounterItem_loginCount").getLong();
                loginCounter_loginDateNode.setProperty("exo:LoginHisSvc_loginCounterItem_loginCount", loginCount + 1L);
            }
            if (DAYS_FOR_KEEPING_USER_STATISTIC > 0 && loginCounter_lastIndex > (long)DAYS_FOR_KEEPING_USER_STATISTIC) {
                QueryManager queryManager = session.getWorkspace().getQueryManager();
                String sqlStatement = "SELECT * FROM exo:LoginHisSvc_loginCounterItem WHERE exo:LoginHisSvc_loginCounterItem_userId = '" + userId + "' " + "AND exo:LoginHisSvc_loginCounterItem_id <= " + Long.toString(loginCounter_lastIndex - (long)DAYS_FOR_KEEPING_USER_STATISTIC);
                QueryImpl query = (QueryImpl)queryManager.createQuery(sqlStatement, "sql");
                QueryResult result = query.execute();
                NodeIterator nodeIterator = result.getNodes();
                while (nodeIterator.hasNext()) {
                    Node node = nodeIterator.nextNode();
                    node.remove();
                }
            }
            loginCounterNode.setProperty("exo:LoginHisSvc_loginCounter_lastIndex", loginCounter_lastIndex);
            Node globalLoginCounterNode = session.getRootNode().getNode(HOME).getNode("AllUsers");
            long globalLoginCounter_lastIndex = globalLoginCounterNode.getProperty("exo:LoginHisSvc_globalLoginCounter_lastIndex").getLong();
            if (!globalLoginCounterNode.hasNode(loginDate)) {
                globalLoginCounter_loginDateNode = globalLoginCounterNode.addNode(loginDate, "exo:LoginHisSvc_loginCounterItem");
                globalLoginCounter_loginDateNode.setProperty("exo:LoginHisSvc_loginCounterItem_id", ++globalLoginCounter_lastIndex);
                globalLoginCounter_loginDateNode.setProperty("exo:LoginHisSvc_loginCounterItem_userId", "AllUsers");
                globalLoginCounter_loginDateNode.setProperty("exo:LoginHisSvc_loginCounterItem_loginDate", Long.parseLong(loginDate));
                globalLoginCounter_loginDateNode.setProperty("exo:LoginHisSvc_loginCounterItem_loginCount", 1L);
            } else {
                globalLoginCounter_loginDateNode = globalLoginCounterNode.getNode(loginDate);
                long loginCount = globalLoginCounter_loginDateNode.getProperty("exo:LoginHisSvc_loginCounterItem_loginCount").getLong();
                globalLoginCounter_loginDateNode.setProperty("exo:LoginHisSvc_loginCounterItem_loginCount", loginCount + 1L);
            }
            if (DAYS_FOR_KEEPING_GLOBAL_STATISTIC > 0 && globalLoginCounter_lastIndex > (long)DAYS_FOR_KEEPING_GLOBAL_STATISTIC) {
                QueryManager queryManager = session.getWorkspace().getQueryManager();
                String sqlStatement = "SELECT * FROM exo:LoginHisSvc_loginCounterItem WHERE exo:LoginHisSvc_loginCounterItem_userId = 'AllUsers' AND exo:LoginHisSvc_loginCounterItem_id <= " + Long.toString(globalLoginCounter_lastIndex - (long)DAYS_FOR_KEEPING_GLOBAL_STATISTIC);
                QueryImpl query = (QueryImpl)queryManager.createQuery(sqlStatement, "sql");
                QueryResult result = query.execute();
                NodeIterator nodeIterator = result.getNodes();
                while (nodeIterator.hasNext()) {
                    Node node = nodeIterator.nextNode();
                    node.remove();
                }
            }
            globalLoginCounterNode.setProperty("exo:LoginHisSvc_globalLoginCounter_lastIndex", globalLoginCounter_lastIndex);
            userNode.save();
            globalLoginCounterNode.save();
        }
        catch (Exception e) {
            log.debug((Object)("Error while adding login history entry for user '" + userId + "': " + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            sProvider.close();
        }
    }

    @Override
    public List<LoginHistoryBean> getLoginHistory(String userId, long fromTime, long toTime) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Session session = this.getSession(sProvider);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String sqlStatement = "SELECT * FROM exo:LoginHisSvc_loginHistoryItem WHERE " + (userId.equals("AllUsers") ? "" : "exo:LoginHisSvc_loginHistoryItem_userId = '" + userId + "' AND ") + "(exo:LoginHisSvc_loginHistoryItem_loginTime BETWEEN " + Long.toString(fromTime) + " AND " + Long.toString(toTime) + ") " + "ORDER BY exo:LoginHisSvc_loginHistoryItem_loginTime DESC";
            QueryImpl query = (QueryImpl)queryManager.createQuery(sqlStatement, "sql");
            QueryResult result = query.execute();
            NodeIterator nodeIterator = result.getNodes();
            ArrayList<LoginHistoryBean> list = new ArrayList<LoginHistoryBean>();
            ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                LoginHistoryBean loginHistory = new LoginHistoryBean();
                String uId = node.getProperty("exo:LoginHisSvc_loginHistoryItem_userId").getString();
                String uName = forumService.getUserInfo(uId).getFullName();
                loginHistory.setUserId(uId);
                loginHistory.setUserName(uName.isEmpty() ? uId : uName);
                loginHistory.setLoginTime(node.getProperty("exo:LoginHisSvc_loginHistoryItem_loginTime").getLong());
                list.add(loginHistory);
            }
            ArrayList<LoginHistoryBean> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            log.debug((Object)("Error while getting login history of user '" + userId + "': " + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            sProvider.close();
        }
    }

    public List<LoginCounterBean> getLoginCountPerDaysInRange(String userId, long fromDate, long toDate) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Session session = this.getSession(sProvider);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String sqlStatement = "SELECT * FROM exo:LoginHisSvc_loginCounterItem WHERE exo:LoginHisSvc_loginCounterItem_userId = '" + userId + "' " + "AND (exo:LoginHisSvc_loginCounterItem_loginDate BETWEEN " + Long.toString(fromDate) + " AND " + Long.toString(toDate) + ") " + "ORDER BY exo:LoginHisSvc_loginCounterItem_loginDate ASC";
            QueryImpl query = (QueryImpl)queryManager.createQuery(sqlStatement, "sql");
            QueryResult result = query.execute();
            NodeIterator nodeIterator = result.getNodes();
            ArrayList<LoginCounterBean> list = new ArrayList<LoginCounterBean>();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                LoginCounterBean loginCountPerDay = new LoginCounterBean();
                loginCountPerDay.setLoginDate(node.getProperty("exo:LoginHisSvc_loginCounterItem_loginDate").getLong());
                loginCountPerDay.setLoginCount(node.getProperty("exo:LoginHisSvc_loginCounterItem_loginCount").getLong());
                list.add(loginCountPerDay);
            }
            ArrayList<LoginCounterBean> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            log.debug((Object)("Error while getting login counts of user '" + userId + "': " + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            sProvider.close();
        }
    }

    private int getLoginCount(String userId, long fromDate, long toDate) throws Exception {
        List<LoginCounterBean> loginCounts = this.getLoginCountPerDaysInRange(userId, fromDate, toDate);
        int sum = 0;
        Iterator<LoginCounterBean> iter = loginCounts.iterator();
        while (iter.hasNext()) {
            sum = (int)((long)sum + iter.next().getLoginCount());
        }
        return sum;
    }

    @Override
    public List<LoginCounterBean> getLoginCountPerDaysInWeek(String userId, long week) throws Exception {
        ArrayList<LoginCounterBean> list = new ArrayList<LoginCounterBean>();
        ArrayList<Long> days = new ArrayList<Long>();
        long now = System.currentTimeMillis();
        long nextWeek = LoginHistoryServiceImpl.nextMonday(week);
        long day = week;
        do {
            LoginCounterBean loginCountPerDay = new LoginCounterBean();
            loginCountPerDay.setLoginDate(day);
            loginCountPerDay.setLoginCount(day > now ? -1L : 0L);
            list.add(loginCountPerDay);
            days.add(day);
        } while ((day += DAY_IN_MILLISEC) < nextWeek);
        List<LoginCounterBean> counters = this.getLoginCountPerDaysInRange(userId, week, LoginHistoryServiceImpl.nextMonday(week) - DAY_IN_MILLISEC);
        for (LoginCounterBean loginCountPerDay : counters) {
            list.set(days.indexOf(loginCountPerDay.getLoginDate()), loginCountPerDay);
        }
        return list;
    }

    @Override
    public List<LoginCounterBean> getLoginCountPerWeeksInMonths(String userId, long fromMonth, int numOfMonths) throws Exception {
        Calendar cal = Calendar.getInstance();
        long now = cal.getTime().getTime();
        cal.setTimeInMillis(fromMonth);
        cal.add(2, numOfMonths);
        long toMonth = cal.getTimeInMillis();
        long toDate = fromMonth;
        ArrayList<LoginCounterBean> list = new ArrayList<LoginCounterBean>();
        do {
            long fromDate = toDate;
            if ((toDate = LoginHistoryServiceImpl.nextMonday(toDate)) > toMonth) {
                toDate = toMonth;
            }
            LoginCounterBean loginCountPerWeek = new LoginCounterBean();
            loginCountPerWeek.setLoginDate(fromDate);
            loginCountPerWeek.setLoginCount(fromDate > now ? -1L : (long)this.getLoginCount(userId, fromDate, toDate - DAY_IN_MILLISEC));
            list.add(loginCountPerWeek);
        } while (toDate < toMonth);
        return list;
    }

    @Override
    public List<LoginCounterBean> getLoginCountPerMonthsInYear(String userId, long year) throws Exception {
        Calendar cal = Calendar.getInstance();
        long now = cal.getTime().getTime();
        cal.setTimeInMillis(year);
        cal.add(1, 1);
        long nextYear = cal.getTimeInMillis();
        long toDate = year;
        ArrayList<LoginCounterBean> list = new ArrayList<LoginCounterBean>();
        do {
            long fromDate = toDate;
            cal.setTimeInMillis(toDate);
            cal.add(2, 1);
            toDate = cal.getTimeInMillis();
            if (toDate > nextYear) {
                toDate = nextYear;
            }
            LoginCounterBean loginCountPerWeek = new LoginCounterBean();
            loginCountPerWeek.setLoginDate(fromDate);
            loginCountPerWeek.setLoginCount(fromDate > now ? -1L : (long)this.getLoginCount(userId, fromDate, toDate - DAY_IN_MILLISEC));
            list.add(loginCountPerWeek);
        } while (toDate < nextYear);
        return list;
    }

    private Session getSession(SessionProvider sessionProvider) throws Exception {
        ManageableRepository currentRepo = this._repoService.getCurrentRepository();
        return sessionProvider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
    }

    private static long nextMonday(long date) {
        Calendar now = Calendar.getInstance();
        now.setTimeInMillis(date);
        int weekday = now.get(7);
        int days = weekday == 1 ? 1 : 7 - weekday + 2;
        now.add(6, days);
        return now.getTimeInMillis();
    }
}

