/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadget.services.ForumStatistics;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumStatistic;
import org.exoplatform.platform.gadget.services.ForumStatistics.ForumsIntranetService;
import org.exoplatform.platform.gadget.services.ForumStatistics.ForumsWeeklyStatisticService;
import org.exoplatform.platform.gadget.services.ForumStatistics.MessageBean;
import org.exoplatform.platform.gadget.services.ForumStatistics.TopicBean;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="forumsService")
public class ForumRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ForumRestService.class);

    @GET
    @Path(value="/forums/statistic/")
    @Produces(value={"application/json"})
    public Response forumsStatistic() {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        ForumStatistic forumStatistic = new ForumStatistic();
        try {
            forumStatistic = forumService.getForumStatistic();
        }
        catch (Exception e) {
            LOG.error((Object)"forumStatistic not found", (Throwable)e);
        }
        ArrayList<Object> dataForumStatistic = new ArrayList<Object>();
        dataForumStatistic.add(forumStatistic);
        MessageBean data = new MessageBean();
        data.setData(dataForumStatistic);
        return Response.ok((Object)data, (String)"application/json").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/forums/weeklystatistic/")
    @Produces(value={"application/json"})
    public Response forumsWeeklyStatistic() {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        ForumsWeeklyStatisticService forumsWeeklyStatisticService = (ForumsWeeklyStatisticService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumsWeeklyStatisticService.class);
        List<Object> listForumsWeeklyStatistic = new ArrayList();
        try {
            listForumsWeeklyStatistic = forumsWeeklyStatisticService.getAllForumsWeeklyStatistic();
        }
        catch (Exception e) {
            LOG.error((Object)"forumWeeklyStatistic not found", (Throwable)e);
        }
        ArrayList<Object> dataForumStatistic = new ArrayList<Object>();
        dataForumStatistic.add(listForumsWeeklyStatistic);
        MessageBean data = new MessageBean();
        data.setData(dataForumStatistic);
        return Response.ok((Object)data, (String)"application/json").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/forums/toprate/{maxcount}")
    @Produces(value={"application/json"})
    public Response forumsTopRated(@PathParam(value="maxcount") int maxcount) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        ForumsIntranetService intranetService = (ForumsIntranetService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumsIntranetService.class);
        try {
            List<TopicBean> beanList = intranetService.getTopRateTopicByUser(this.getAllGroupAndMembershipOfUser(), maxcount);
            ArrayList<Object> listData = new ArrayList<Object>();
            listData.add(beanList);
            MessageBean data = new MessageBean();
            data.setData(listData);
            return Response.ok((Object)data, (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.debug((Object)"Failed to get top voted rating topics");
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }

    private List<String> getAllGroupAndMembershipOfUser() {
        ArrayList<String> listOfUser = new ArrayList<String>();
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            listOfUser.add(identity.getUserId());
            HashSet<String> list = new HashSet<String>();
            list.addAll(identity.getGroups());
            for (MembershipEntry membership : identity.getMemberships()) {
                String value = membership.getGroup();
                list.add(value);
                value = new StringBuffer().append(membership.getMembershipType()).append(":").append(value).toString();
                list.add(value);
            }
            listOfUser.addAll(list);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to add all info of user.");
        }
        return listOfUser;
    }
}

