/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.space.listeners;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.platform.common.space.SpaceCustomizationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

public class CustomizeSpaceDriveListener
extends SpaceListenerPlugin {
    private static final String SPACE_DRIVE_VIEW = "space.drive.view";
    private SpaceCustomizationService spaceCustomizationService = null;
    private String viewNodeName = null;
    private static final Log LOG = ExoLogger.getExoLogger(CustomizeSpaceDriveListener.class);

    public CustomizeSpaceDriveListener(SpaceCustomizationService spaceCustomizationService_, InitParams params) {
        this.spaceCustomizationService = spaceCustomizationService_;
        ValueParam viewParamName = params.getValueParam(SPACE_DRIVE_VIEW);
        if (viewParamName != null) {
            this.viewNodeName = viewParamName.getValue();
        } else {
            LOG.warn((Object)"No such property found: space.drive.view\nPlease make sure to have the correct ECMS view name.");
        }
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
        String groupId = event.getSpace().getGroupId();
        String permission = "manager:" + groupId;
        try {
            if (this.viewNodeName != null) {
                this.spaceCustomizationService.editSpaceDriveViewPermissions(this.viewNodeName, permission);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Can not edit view's permissions for view node: null");
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Can not edit view's permission for space drive: " + groupId), (Throwable)e);
        }
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
    }

    public void applicationAdded(SpaceLifeCycleEvent event) {
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
    }

    public void joined(SpaceLifeCycleEvent event) {
    }

    public void left(SpaceLifeCycleEvent event) {
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
    }

    public void spaceRenamed(SpaceLifeCycleEvent event) {
    }

    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAccessEdited(SpaceLifeCycleEvent event) {
    }

    public void addInvitedUser(SpaceLifeCycleEvent event) {
    }

    public void addPendingUser(SpaceLifeCycleEvent event) {
    }
}

