/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.ext;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.security.IdentityConstants;

public class UserDriveExtListener
extends UserEventListener {
    private static final Log LOG = ExoLogger.getLogger(UserDriveExtListener.class);
    private static final String SYMLINK_NAME = "Public";
    private static final String SYMLIN_TYPE = "exo:symlink";
    private static final String PUPLIC_DRIVE_EXT = "/Public";
    private static final String PRIVATE_DRIVE_EXT = "/Private";
    private static final String WORKSPACE = "exo:workspace";
    private static final String UUID = "exo:uuid";
    private static final String PRIMARY_TYPE = "exo:primaryType";
    private final RepositoryService repositoryService_;
    private final LinkManager linkManager_;
    private NodeHierarchyCreator nodeHierarchyCreator_;

    public UserDriveExtListener(RepositoryService repositoryService, LinkManager linkManager, NodeHierarchyCreator nodeHierarchyCreator) throws Exception {
        this.repositoryService_ = repositoryService;
        this.linkManager_ = linkManager;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
    }

    public void postSave(User user, boolean isNew) throws Exception {
        if (isNew) {
            this.createLink(user.getUserName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLink(String userName) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        Session session = this.getSession(sessionProvider);
        String privatePathUserFolder = "";
        String publicPathUserFolder = "";
        try {
            Node userNode = this.nodeHierarchyCreator_.getUserNode(sessionProvider, userName);
            privatePathUserFolder = userNode.getPath().concat(PRIVATE_DRIVE_EXT);
            publicPathUserFolder = userNode.getPath().concat(PUPLIC_DRIVE_EXT);
            Node symLinkParent = (Node)session.getItem(privatePathUserFolder);
            Node targetNode = (Node)session.getItem(publicPathUserFolder);
            Node linkNode = null;
            linkNode = this.createLink(symLinkParent, SYMLIN_TYPE, targetNode, SYMLINK_NAME);
            ((ExtendedNode)linkNode).setPermission(IdentityConstants.ANY, new String[]{"read"});
            linkNode.save();
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurs while processing the creation of Public Symlink ", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    private Session getSession(SessionProvider sessionProvider) throws RepositoryException {
        ManageableRepository repository = this.repositoryService_.getCurrentRepository();
        return sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
    }

    private Node createLink(Node parent, String linkType, Node target, String linkName) throws RepositoryException {
        if (!target.isNodeType(SYMLIN_TYPE)) {
            Node linkNode;
            block6: {
                if (target.canAddMixin("mix:referenceable")) {
                    target.addMixin("mix:referenceable");
                    target.getSession().save();
                }
                if (linkType == null || linkType.trim().length() == 0) {
                    linkType = SYMLIN_TYPE;
                }
                if (linkName == null || linkName.trim().length() == 0) {
                    linkName = target.getName();
                }
                linkNode = parent.addNode(linkName, linkType);
                try {
                    this.updateAccessPermissionToLink(linkNode, target);
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block6;
                    LOG.error((Object)"CAN NOT UPDATE ACCESS PERMISSIONS FROM TARGET NODE TO LINK NODE", (Throwable)e);
                }
            }
            linkNode.setProperty(WORKSPACE, target.getSession().getWorkspace().getName());
            linkNode.setProperty(PRIMARY_TYPE, target.getPrimaryNodeType().getName());
            linkNode.setProperty(UUID, target.getUUID());
            linkNode.getSession().save();
            return linkNode;
        }
        return null;
    }

    private boolean canChangePermission(Node node) throws RepositoryException {
        try {
            ((ExtendedNode)node).checkPermission("add_node,set_property,remove");
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    private void updateAccessPermissionToLink(Node linkNode, Node targetNode) throws Exception {
        if (this.canChangePermission(linkNode)) {
            if (linkNode.canAddMixin("exo:privilegeable")) {
                linkNode.addMixin("exo:privilegeable");
                ((ExtendedNode)linkNode).setPermission(this.getNodeOwner(linkNode), PermissionType.ALL);
            }
            this.removeCurrentIdentites(linkNode);
            HashMap<String, String[]> perMap = new HashMap<String, String[]>();
            List permsList = new ArrayList();
            ArrayList<String> idList = new ArrayList<String>();
            for (AccessControlEntry accessEntry : ((ExtendedNode)targetNode).getACL().getPermissionEntries()) {
                if (idList.contains(accessEntry.getIdentity())) continue;
                idList.add(accessEntry.getIdentity());
                permsList = ((ExtendedNode)targetNode).getACL().getPermissions(accessEntry.getIdentity());
                perMap.put(accessEntry.getIdentity(), permsList.toArray(new String[permsList.size()]));
            }
            ((ExtendedNode)linkNode).setPermissions(perMap);
        }
    }

    private String getNodeOwner(Node node) throws ValueFormatException, PathNotFoundException, RepositoryException {
        if (node.hasProperty("exo:owner")) {
            return node.getProperty("exo:owner").getString();
        }
        return IdentityConstants.SYSTEM;
    }

    private void removeCurrentIdentites(Node linkNode) throws AccessControlException, RepositoryException {
        String currentUser = linkNode.getSession().getUserID();
        if (currentUser != null) {
            ((ExtendedNode)linkNode).setPermission(currentUser, PermissionType.ALL);
        }
        for (AccessControlEntry accessEntry : ((ExtendedNode)linkNode).getACL().getPermissionEntries()) {
            if (!this.canRemovePermission(linkNode, accessEntry.getIdentity()) || ((ExtendedNode)linkNode).getACL().getPermissions(accessEntry.getIdentity()).size() <= 0 || accessEntry.getIdentity().equals(currentUser)) continue;
            ((ExtendedNode)linkNode).removePermission(accessEntry.getIdentity());
        }
    }

    private boolean canRemovePermission(Node node, String identity) throws ValueFormatException, PathNotFoundException, RepositoryException {
        String owner = this.getNodeOwner(node);
        if (identity.equals(IdentityConstants.SYSTEM)) {
            return false;
        }
        return owner == null || !owner.equals(identity);
    }
}

