/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.software.register.service.impl;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.jcr.Node;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.chromattic.api.ChromatticSession;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.common.rest.PlatformInformationRESTService;
import org.exoplatform.platform.common.software.register.UnlockService;
import org.exoplatform.platform.common.software.register.Utils;
import org.exoplatform.platform.common.software.register.model.SoftwareRegistration;
import org.exoplatform.platform.common.software.register.service.SoftwareRegistrationService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONObject;

public class SoftwareRegistrationServiceImpl
implements SoftwareRegistrationService {
    private static final Log LOG = ExoLogger.getLogger(SoftwareRegistrationServiceImpl.class);
    private static final String CHROMATTIC_LIFECYCLE_NAME = "softwareRegistration";
    private static final String SW_NODE_NAME = "SoftwareRegistration";
    private ChromatticLifeCycle lifeCycle;
    private NodeHierarchyCreator nodeHierarchyCreator;
    private static boolean hasSoftwareRegisteredNode = false;
    private static SettingService settingService;
    private PlatformInformationRESTService platformInformationRESTService;
    private InitParams initParams;
    private String softwareRegistrationHost;
    private UnlockService unlockService;
    private boolean isRequestSkip;
    private int skipedNum;
    private String currStatus;
    private String currVersions;

    public ChromatticSession getSession() {
        return this.lifeCycle.getChromattic().openSession();
    }

    public SoftwareRegistrationServiceImpl(ChromatticManager chromatticManager, NodeHierarchyCreator nodeHierarchyCreator, SettingService settingService, PlatformInformationRESTService platformInformationRESTService, InitParams initParams, UnlockService unlockService) {
        block3: {
            this.softwareRegistrationHost = "https://community.exoplatform.com";
            this.skipedNum = 0;
            this.lifeCycle = chromatticManager.getLifeCycle(CHROMATTIC_LIFECYCLE_NAME);
            this.nodeHierarchyCreator = nodeHierarchyCreator;
            SoftwareRegistrationServiceImpl.settingService = settingService;
            this.platformInformationRESTService = platformInformationRESTService;
            this.initParams = initParams;
            if (initParams != null && initParams.getValueParam("registration.host") != null) {
                this.softwareRegistrationHost = initParams.getValueParam("registration.host").getValue();
            }
            this.unlockService = unlockService;
            this.currStatus = Utils.readFromFile("status", Utils.HOME_CONFIG_FILE_LOCATION);
            this.currVersions = Utils.readFromFile(platformInformationRESTService.getPlatformEdition().concat("-").concat("version"), Utils.HOME_CONFIG_FILE_LOCATION);
            try {
                this.skipedNum = Integer.parseInt(initParams.getValueParam("registration.skipAllow").getValue());
            }
            catch (NumberFormatException nfe) {
                if (!LOG.isWarnEnabled()) break block3;
                LOG.warn((Object)"Skip allow configuration of PLF registration has been ignored!");
            }
        }
    }

    @Override
    public boolean isSkipPlatformRegistration() {
        String skipPLFRegister = this.initParams.getValueParam("registration.skip").getValue();
        if (skipPLFRegister == null) {
            return false;
        }
        return StringUtils.equals((String)"true", (String)skipPLFRegister.trim());
    }

    @Override
    public SoftwareRegistration registrationPLF(String code, String returnURL) {
        String url = this.softwareRegistrationHost + "/portal/accessToken";
        SoftwareRegistration softwareRegistration = new SoftwareRegistration();
        try {
            DefaultHttpClient client = new DefaultHttpClient();
            HttpPost post = new HttpPost(url);
            ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
            urlParameters.add(new BasicNameValuePair("grant_type", "authorization_code"));
            urlParameters.add(new BasicNameValuePair("code", code));
            urlParameters.add(new BasicNameValuePair("redirect_uri", returnURL));
            urlParameters.add(new BasicNameValuePair("client_id", "x6iCo6YWmw"));
            urlParameters.add(new BasicNameValuePair("client_secret", "3XNzbpuTSx5HqJsBSwgl"));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters));
            HttpResponse response = client.execute((HttpUriRequest)post);
            BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer result = new StringBuffer();
            String line = "";
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            JSONObject responseData = new JSONObject(result.toString());
            if (response.getStatusLine().getStatusCode() == 200) {
                String accessToken = responseData.getString("access_token");
                softwareRegistration.setAccess_token(accessToken);
                boolean pushInfo = this.sendPlfInformation(accessToken);
                softwareRegistration.setPushInfo(pushInfo);
            } else {
                String errorCode = responseData.getString("error");
                softwareRegistration.setError_code(errorCode);
            }
            return softwareRegistration;
        }
        catch (Exception ex) {
            softwareRegistration.setNotReachable(true);
            return softwareRegistration;
        }
    }

    @Override
    public void updateSkippedNumber() {
        int skippedNumber = this.getSkippedNumber();
        settingService.set(Context.GLOBAL, Scope.GLOBAL, "softwareRegistrationSkipped", new SettingValue((Object)String.valueOf(++skippedNumber)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canSkipRegister() {
        int _skipedNum = this.getSkippedNumber();
        if (_skipedNum <= this.skipedNum) return true;
        SoftwareRegistrationServiceImpl softwareRegistrationServiceImpl = this;
        if (!softwareRegistrationServiceImpl.unlockService.isUnlocked()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canShowSkipBtn() {
        int _skipedNum = this.getSkippedNumber();
        if (_skipedNum < this.skipedNum) return true;
        SoftwareRegistrationServiceImpl softwareRegistrationServiceImpl = this;
        if (!softwareRegistrationServiceImpl.unlockService.isUnlocked()) return false;
        return true;
    }

    private int getSkippedNumber() {
        SettingValue settingValue = settingService.get(Context.GLOBAL, Scope.GLOBAL, "softwareRegistrationSkipped");
        if (settingValue != null) {
            return Integer.parseInt(settingValue.getValue().toString());
        }
        settingService.set(Context.GLOBAL, Scope.GLOBAL, "softwareRegistrationSkipped", new SettingValue((Object)"0"));
        return 0;
    }

    @Override
    public boolean isSoftwareRegistered() {
        if (StringUtils.isEmpty((String)this.currStatus) || StringUtils.isEmpty((String)this.currVersions)) {
            return false;
        }
        boolean plfRegistrationStatus = this.currStatus.contains(this.platformInformationRESTService.getPlatformEdition().concat("-true"));
        boolean plfVersionRegistrationStatus = this.currVersions.contains(this.platformInformationRESTService.getJsonPlatformInfo().getPlatformVersion());
        return plfRegistrationStatus && plfVersionRegistrationStatus;
    }

    @Override
    public void checkSoftwareRegistration() {
        String currentRegStatus = Utils.readFromFile("status", Utils.HOME_CONFIG_FILE_LOCATION);
        if (StringUtils.isEmpty((String)currentRegStatus)) {
            currentRegStatus = this.platformInformationRESTService.getPlatformEdition().concat("-true");
        } else if (!currentRegStatus.contains(this.platformInformationRESTService.getPlatformEdition().concat("-true"))) {
            currentRegStatus = currentRegStatus.concat(",").concat(this.platformInformationRESTService.getPlatformEdition().concat("-true"));
        }
        Utils.writeToFile("status", currentRegStatus, Utils.HOME_CONFIG_FILE_LOCATION);
        this.currStatus = currentRegStatus;
        String plfVersionsKey = this.platformInformationRESTService.getPlatformEdition().concat("-").concat("version");
        String plfVersions = Utils.readFromFile(plfVersionsKey, Utils.HOME_CONFIG_FILE_LOCATION);
        if (StringUtils.isEmpty((String)plfVersions)) {
            plfVersions = this.platformInformationRESTService.getJsonPlatformInfo().getPlatformVersion();
        } else if (!plfVersions.contains(this.platformInformationRESTService.getJsonPlatformInfo().getPlatformVersion())) {
            plfVersions = plfVersions.concat(",").concat(this.platformInformationRESTService.getJsonPlatformInfo().getPlatformVersion());
        }
        Utils.writeToFile(this.platformInformationRESTService.getPlatformEdition().concat("-").concat("version"), plfVersions, Utils.HOME_CONFIG_FILE_LOCATION);
        this.currVersions = plfVersions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSoftwareRegistrationNode() {
        try (SessionProvider sessionProvider = SessionProvider.createSystemProvider();){
            Node publicApplicationNode = this.nodeHierarchyCreator.getPublicApplicationNode(sessionProvider);
            if (!publicApplicationNode.hasNode(SW_NODE_NAME)) {
                publicApplicationNode = publicApplicationNode.addNode(SW_NODE_NAME, "nt:folder");
                publicApplicationNode.addMixin("mix:referenceable");
                publicApplicationNode.getSession().save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasSoftwareRegistration() {
        SessionProvider sessionProvider = null;
        try {
            if (hasSoftwareRegisteredNode) {
                return hasSoftwareRegisteredNode;
            }
            try {
                sessionProvider = SessionProvider.createSystemProvider();
                Node publicApplicationNode = this.nodeHierarchyCreator.getPublicApplicationNode(sessionProvider);
                hasSoftwareRegisteredNode = publicApplicationNode.hasNode(SW_NODE_NAME);
            }
            catch (Exception e) {
                LOG.error((Object)"Software Registration: cannot get node", (Throwable)e);
                hasSoftwareRegisteredNode = false;
            }
            finally {
                sessionProvider.close();
            }
            return hasSoftwareRegisteredNode;
        }
        catch (Exception e) {
            LOG.error((Object)"Software Registration: cannot check node", (Throwable)e);
            return hasSoftwareRegisteredNode;
        }
    }

    private boolean sendPlfInformation(String accessTokencode) {
        try {
            String url = this.softwareRegistrationHost + "/portal/rest/registerSoftware/register";
            DefaultHttpClient client = new DefaultHttpClient();
            HttpPost httpPost = new HttpPost(url);
            PlatformInformationRESTService.JsonPlatformInfo jsonPlatformInfo = this.platformInformationRESTService.getJsonPlatformInfo();
            JSONObject jsonObj = new JSONObject((Object)jsonPlatformInfo);
            String input = jsonObj.toString();
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setHeader("Authorization", "Bearer " + accessTokencode);
            httpPost.setEntity((HttpEntity)new StringEntity(input));
            HttpResponse response = client.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() != 200) {
                LOG.warn((Object)("Failed : HTTP error code : " + response.getStatusLine().getStatusCode()));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOG.warn((Object)"Can not send Platform information to eXo community", (Throwable)e);
            return false;
        }
    }

    @Override
    public String getSoftwareRegistrationHost() {
        return this.softwareRegistrationHost;
    }

    @Override
    public boolean isRequestSkip() {
        return this.isRequestSkip;
    }

    @Override
    public void setRequestSkip(boolean isRequestSkip) {
        this.isRequestSkip = isRequestSkip;
    }
}

