/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.rest;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.user.UserStateModel;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/state/")
public class RESTUserService
implements ResourceContainer {
    private final UserStateService userService;
    protected static final String ACTIVITY = "activity";
    protected static final String STATUS = "status";
    private static final int MAX_USER = 17;
    private static final int INDEX_USER = 18;

    public RESTUserService(UserStateService userService) {
        this.userService = userService;
    }

    @GET
    @Path(value="/ping/")
    @RolesAllowed(value={"users"})
    public Response updateState() {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        this.userService.ping(userId);
        return Response.ok().cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/onlinefriends")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response onlineFriends() throws Exception {
        try {
            String userId = ConversationState.getCurrent().getIdentity().getUserId();
            List<User> users = this.getOnlineFriends(userId);
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            cacheControl.setNoStore(true);
            return Response.ok(users, (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="/status/")
    @RolesAllowed(value={"users"})
    public Response online() throws ParserConfigurationException, JSONException {
        List usersOnline = this.userService.online();
        if (usersOnline == null) {
            return Response.ok().build();
        }
        JSONArray json = new JSONArray();
        for (UserStateModel model : usersOnline) {
            json.put((Object)this.fillModelToJson(model));
        }
        return Response.ok((Object)json.toString(), (String)"application/json").build();
    }

    private JSONObject fillModelToJson(UserStateModel model) throws JSONException {
        JSONObject object = new JSONObject();
        object.put(ACTIVITY, (Object)"offline");
        object.put("userId", (Object)model.getUserId());
        Date date = new Date(model.getLastActivity());
        SimpleDateFormat ISO_8601_DATE_TIME = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        String lastActivityDate = ISO_8601_DATE_TIME.format(date);
        object.put("lastActivityDate", (Object)lastActivityDate);
        object.put(STATUS, (Object)model.getStatus());
        if (this.userService.isOnline(model.getUserId())) {
            object.put(ACTIVITY, (Object)"online");
        }
        return object;
    }

    @GET
    @Path(value="/status/{userId}/")
    @RolesAllowed(value={"users"})
    public Response getStatus(@PathParam(value="userId") String userId) throws JSONException {
        UserStateModel model = this.userService.getUserState(userId);
        if (model == null) {
            return Response.noContent().build();
        }
        JSONObject object = this.fillModelToJson(model);
        return Response.ok((Object)object.toString(), (String)"application/json").build();
    }

    @PUT
    @Path(value="/status/{userId}/")
    @RolesAllowed(value={"users"})
    @Deprecated
    public Response setStatus(@PathParam(value="userId") String userId, @QueryParam(value="status") String status) throws JSONException {
        String authenticated = ConversationState.getCurrent().getIdentity().getUserId();
        if (!authenticated.equals(userId)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        UserStateModel model = this.userService.getUserState(userId);
        if (StringUtils.isNotEmpty((String)status)) {
            model.setStatus(status);
            this.userService.save(model);
            return Response.ok().build();
        }
        return Response.notModified().build();
    }

    @PUT
    @Path(value="/status")
    @RolesAllowed(value={"users"})
    public Response setStatus(@QueryParam(value="status") String status) throws JSONException {
        String authenticated = ConversationState.getCurrent().getIdentity().getUserId();
        UserStateModel model = this.userService.getUserState(authenticated);
        if (StringUtils.isNotEmpty((String)status)) {
            model.setStatus(status);
            this.userService.save(model);
            return Response.ok().build();
        }
        return Response.notModified().build();
    }

    private List<User> getOnlineFriends(String userId) {
        ArrayList<User> userOnLineList = new ArrayList<User>();
        if (userId == null) {
            return userOnLineList;
        }
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            IdentityManager identityManager = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
            UserStateService userStateService = (UserStateService)container.getComponentInstanceOfType(UserStateService.class);
            List users = userStateService.online();
            Collections.reverse(users);
            if (users.size() > 17) {
                users = users.subList(0, 18);
            }
            String superUserName = System.getProperty("exo.super.user");
            for (UserStateModel userModel : users) {
                String user = userModel.getUserId();
                if (user.equals(userId) || user.equals(superUserName)) continue;
                User userOnLine = new User();
                Identity userIdentity = identityManager.getOrCreateIdentity("organization", user, false);
                Profile userProfile = userIdentity.getProfile();
                userOnLine.setId(userProfile.getId());
                userOnLine.setProfileUrl(LinkProvider.getUserProfileUri((String)userIdentity.getRemoteId()));
                userOnLine.setAvatar(userProfile.getAvatarImageSource() != null ? userProfile.getAvatarImageSource() : "/eXoSkin/skin/images/system/UserAvtDefault.png");
                userOnLineList.add(userOnLine);
            }
            return userOnLineList;
        }
        catch (Exception e) {
            return null;
        }
    }

    public class User {
        String id;
        String profileUrl;
        String avatar;

        public void setId(String userId) {
            this.id = userId;
        }

        public void setProfileUrl(String profileUrl) {
            this.profileUrl = profileUrl;
        }

        public void setAvatar(String avatar) {
            this.avatar = avatar;
        }

        public String getId() {
            return this.id;
        }

        public String getProfileUrl() {
            return this.profileUrl;
        }

        public String getAvatar() {
            return this.avatar;
        }
    }
}

